package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class InlineLoggingBuilder extends InlineLoggingFluent<InlineLoggingBuilder> implements VisitableBuilder<InlineLogging,InlineLoggingBuilder>{
  public InlineLoggingBuilder() {
    this(new InlineLogging());
  }
  
  public InlineLoggingBuilder(InlineLoggingFluent<?> fluent) {
    this(fluent, new InlineLogging());
  }
  
  public InlineLoggingBuilder(InlineLoggingFluent<?> fluent,InlineLogging instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public InlineLoggingBuilder(InlineLogging instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  InlineLoggingFluent<?> fluent;
  
  public InlineLogging build() {
    InlineLogging buildable = new InlineLogging();
    buildable.setLoggers(fluent.getLoggers());
    return buildable;
  }
  

}