package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GenericSecretSourceBuilder extends GenericSecretSourceFluent<GenericSecretSourceBuilder> implements VisitableBuilder<GenericSecretSource,GenericSecretSourceBuilder>{
  public GenericSecretSourceBuilder() {
    this(new GenericSecretSource());
  }
  
  public GenericSecretSourceBuilder(GenericSecretSourceFluent<?> fluent) {
    this(fluent, new GenericSecretSource());
  }
  
  public GenericSecretSourceBuilder(GenericSecretSourceFluent<?> fluent,GenericSecretSource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GenericSecretSourceBuilder(GenericSecretSource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GenericSecretSourceFluent<?> fluent;
  
  public GenericSecretSource build() {
    GenericSecretSource buildable = new GenericSecretSource();
    buildable.setSecretName(fluent.getSecretName());
    buildable.setKey(fluent.getKey());
    return buildable;
  }
  

}