package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ExternalConfigurationReferenceBuilder extends ExternalConfigurationReferenceFluent<ExternalConfigurationReferenceBuilder> implements VisitableBuilder<ExternalConfigurationReference,ExternalConfigurationReferenceBuilder>{
  public ExternalConfigurationReferenceBuilder() {
    this(new ExternalConfigurationReference());
  }
  
  public ExternalConfigurationReferenceBuilder(ExternalConfigurationReferenceFluent<?> fluent) {
    this(fluent, new ExternalConfigurationReference());
  }
  
  public ExternalConfigurationReferenceBuilder(ExternalConfigurationReferenceFluent<?> fluent,ExternalConfigurationReference instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ExternalConfigurationReferenceBuilder(ExternalConfigurationReference instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ExternalConfigurationReferenceFluent<?> fluent;
  
  public ExternalConfigurationReference build() {
    ExternalConfigurationReference buildable = new ExternalConfigurationReference();
    buildable.setConfigMapKeyRef(fluent.getConfigMapKeyRef());
    return buildable;
  }
  

}