package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClientTlsBuilder extends ClientTlsFluent<ClientTlsBuilder> implements VisitableBuilder<ClientTls,ClientTlsBuilder>{
  public ClientTlsBuilder() {
    this(new ClientTls());
  }
  
  public ClientTlsBuilder(ClientTlsFluent<?> fluent) {
    this(fluent, new ClientTls());
  }
  
  public ClientTlsBuilder(ClientTlsFluent<?> fluent,ClientTls instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClientTlsBuilder(ClientTls instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClientTlsFluent<?> fluent;
  
  public ClientTls build() {
    ClientTls buildable = new ClientTls();
    buildable.setTrustedCertificates(fluent.buildTrustedCertificates());
    return buildable;
  }
  

}