package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CertificateAuthorityBuilder extends CertificateAuthorityFluent<CertificateAuthorityBuilder> implements VisitableBuilder<CertificateAuthority,CertificateAuthorityBuilder>{
  public CertificateAuthorityBuilder() {
    this(new CertificateAuthority());
  }
  
  public CertificateAuthorityBuilder(CertificateAuthorityFluent<?> fluent) {
    this(fluent, new CertificateAuthority());
  }
  
  public CertificateAuthorityBuilder(CertificateAuthorityFluent<?> fluent,CertificateAuthority instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CertificateAuthorityBuilder(CertificateAuthority instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CertificateAuthorityFluent<?> fluent;
  
  public CertificateAuthority build() {
    CertificateAuthority buildable = new CertificateAuthority();
    buildable.setValidityDays(fluent.getValidityDays());
    buildable.setGenerateCertificateAuthority(fluent.isGenerateCertificateAuthority());
    buildable.setGenerateSecretOwnerReference(fluent.isGenerateSecretOwnerReference());
    buildable.setRenewalDays(fluent.getRenewalDays());
    buildable.setCertificateExpirationPolicy(fluent.getCertificateExpirationPolicy());
    return buildable;
  }
  

}