package io.strimzi.api.kafka.model.common;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CertSecretSourceFluent<A extends CertSecretSourceFluent<A>> extends BaseFluent<A>{
  public CertSecretSourceFluent() {
  }
  
  public CertSecretSourceFluent(CertSecretSource instance) {
    this.copyInstance(instance);
  }
  private String secretName;
  private String certificate;
  private String pattern;
  
  protected void copyInstance(CertSecretSource instance) {
    instance = (instance != null ? instance : new CertSecretSource());
    if (instance != null) {
          this.withSecretName(instance.getSecretName());
          this.withCertificate(instance.getCertificate());
          this.withPattern(instance.getPattern());
        }
  }
  
  public String getSecretName() {
    return this.secretName;
  }
  
  public A withSecretName(String secretName) {
    this.secretName = secretName;
    return (A) this;
  }
  
  public boolean hasSecretName() {
    return this.secretName != null;
  }
  
  public String getCertificate() {
    return this.certificate;
  }
  
  public A withCertificate(String certificate) {
    this.certificate = certificate;
    return (A) this;
  }
  
  public boolean hasCertificate() {
    return this.certificate != null;
  }
  
  public String getPattern() {
    return this.pattern;
  }
  
  public A withPattern(String pattern) {
    this.pattern = pattern;
    return (A) this;
  }
  
  public boolean hasPattern() {
    return this.pattern != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CertSecretSourceFluent that = (CertSecretSourceFluent) o;
    if (!java.util.Objects.equals(secretName, that.secretName)) return false;
    if (!java.util.Objects.equals(certificate, that.certificate)) return false;
    if (!java.util.Objects.equals(pattern, that.pattern)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(secretName,  certificate,  pattern,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (secretName != null) { sb.append("secretName:"); sb.append(secretName + ","); }
    if (certificate != null) { sb.append("certificate:"); sb.append(certificate + ","); }
    if (pattern != null) { sb.append("pattern:"); sb.append(pattern); }
    sb.append("}");
    return sb.toString();
  }
  

}