package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CertSecretSourceBuilder extends CertSecretSourceFluent<CertSecretSourceBuilder> implements VisitableBuilder<CertSecretSource,CertSecretSourceBuilder>{
  public CertSecretSourceBuilder() {
    this(new CertSecretSource());
  }
  
  public CertSecretSourceBuilder(CertSecretSourceFluent<?> fluent) {
    this(fluent, new CertSecretSource());
  }
  
  public CertSecretSourceBuilder(CertSecretSourceFluent<?> fluent,CertSecretSource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CertSecretSourceBuilder(CertSecretSource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CertSecretSourceFluent<?> fluent;
  
  public CertSecretSource build() {
    CertSecretSource buildable = new CertSecretSource();
    buildable.setSecretName(fluent.getSecretName());
    buildable.setCertificate(fluent.getCertificate());
    buildable.setPattern(fluent.getPattern());
    return buildable;
  }
  

}