package io.strimzi.api.kafka.model.common;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CertAndKeySecretSourceFluent<A extends CertAndKeySecretSourceFluent<A>> extends BaseFluent<A>{
  public CertAndKeySecretSourceFluent() {
  }
  
  public CertAndKeySecretSourceFluent(CertAndKeySecretSource instance) {
    this.copyInstance(instance);
  }
  private String secretName;
  private String certificate;
  private String key;
  
  protected void copyInstance(CertAndKeySecretSource instance) {
    instance = (instance != null ? instance : new CertAndKeySecretSource());
    if (instance != null) {
          this.withSecretName(instance.getSecretName());
          this.withCertificate(instance.getCertificate());
          this.withKey(instance.getKey());
        }
  }
  
  public String getSecretName() {
    return this.secretName;
  }
  
  public A withSecretName(String secretName) {
    this.secretName = secretName;
    return (A) this;
  }
  
  public boolean hasSecretName() {
    return this.secretName != null;
  }
  
  public String getCertificate() {
    return this.certificate;
  }
  
  public A withCertificate(String certificate) {
    this.certificate = certificate;
    return (A) this;
  }
  
  public boolean hasCertificate() {
    return this.certificate != null;
  }
  
  public String getKey() {
    return this.key;
  }
  
  public A withKey(String key) {
    this.key = key;
    return (A) this;
  }
  
  public boolean hasKey() {
    return this.key != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CertAndKeySecretSourceFluent that = (CertAndKeySecretSourceFluent) o;
    if (!java.util.Objects.equals(secretName, that.secretName)) return false;
    if (!java.util.Objects.equals(certificate, that.certificate)) return false;
    if (!java.util.Objects.equals(key, that.key)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(secretName,  certificate,  key,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (secretName != null) { sb.append("secretName:"); sb.append(secretName + ","); }
    if (certificate != null) { sb.append("certificate:"); sb.append(certificate + ","); }
    if (key != null) { sb.append("key:"); sb.append(key); }
    sb.append("}");
    return sb.toString();
  }
  

}