package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CertAndKeySecretSourceBuilder extends CertAndKeySecretSourceFluent<CertAndKeySecretSourceBuilder> implements VisitableBuilder<CertAndKeySecretSource,CertAndKeySecretSourceBuilder>{
  public CertAndKeySecretSourceBuilder() {
    this(new CertAndKeySecretSource());
  }
  
  public CertAndKeySecretSourceBuilder(CertAndKeySecretSourceFluent<?> fluent) {
    this(fluent, new CertAndKeySecretSource());
  }
  
  public CertAndKeySecretSourceBuilder(CertAndKeySecretSourceFluent<?> fluent,CertAndKeySecretSource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CertAndKeySecretSourceBuilder(CertAndKeySecretSource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CertAndKeySecretSourceFluent<?> fluent;
  
  public CertAndKeySecretSource build() {
    CertAndKeySecretSource buildable = new CertAndKeySecretSource();
    buildable.setSecretName(fluent.getSecretName());
    buildable.setCertificate(fluent.getCertificate());
    buildable.setKey(fluent.getKey());
    return buildable;
  }
  

}