package io.strimzi.api.kafka.model.bridge;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaBridgeTemplateBuilder extends KafkaBridgeTemplateFluent<KafkaBridgeTemplateBuilder> implements VisitableBuilder<KafkaBridgeTemplate,KafkaBridgeTemplateBuilder>{
  public KafkaBridgeTemplateBuilder() {
    this(new KafkaBridgeTemplate());
  }
  
  public KafkaBridgeTemplateBuilder(KafkaBridgeTemplateFluent<?> fluent) {
    this(fluent, new KafkaBridgeTemplate());
  }
  
  public KafkaBridgeTemplateBuilder(KafkaBridgeTemplateFluent<?> fluent,KafkaBridgeTemplate instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaBridgeTemplateBuilder(KafkaBridgeTemplate instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaBridgeTemplateFluent<?> fluent;
  
  public KafkaBridgeTemplate build() {
    KafkaBridgeTemplate buildable = new KafkaBridgeTemplate();
    buildable.setDeployment(fluent.buildDeployment());
    buildable.setPod(fluent.buildPod());
    buildable.setApiService(fluent.buildApiService());
    buildable.setPodDisruptionBudget(fluent.buildPodDisruptionBudget());
    buildable.setBridgeContainer(fluent.buildBridgeContainer());
    buildable.setInitContainer(fluent.buildInitContainer());
    buildable.setClusterRoleBinding(fluent.buildClusterRoleBinding());
    buildable.setServiceAccount(fluent.buildServiceAccount());
    return buildable;
  }
  

}