package io.strimzi.api.kafka.model.bridge;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaBridgeStatusBuilder extends KafkaBridgeStatusFluent<KafkaBridgeStatusBuilder> implements VisitableBuilder<KafkaBridgeStatus,KafkaBridgeStatusBuilder>{
  public KafkaBridgeStatusBuilder() {
    this(new KafkaBridgeStatus());
  }
  
  public KafkaBridgeStatusBuilder(KafkaBridgeStatusFluent<?> fluent) {
    this(fluent, new KafkaBridgeStatus());
  }
  
  public KafkaBridgeStatusBuilder(KafkaBridgeStatusFluent<?> fluent,KafkaBridgeStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaBridgeStatusBuilder(KafkaBridgeStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaBridgeStatusFluent<?> fluent;
  
  public KafkaBridgeStatus build() {
    KafkaBridgeStatus buildable = new KafkaBridgeStatus();
    buildable.setUrl(fluent.getUrl());
    buildable.setReplicas(fluent.getReplicas());
    buildable.setLabelSelector(fluent.getLabelSelector());
    buildable.setConditions(fluent.buildConditions());
    buildable.setObservedGeneration(fluent.getObservedGeneration());
    return buildable;
  }
  

}