package io.strimzi.api.kafka.model.bridge;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaBridgeSpecBuilder extends KafkaBridgeSpecFluent<KafkaBridgeSpecBuilder> implements VisitableBuilder<KafkaBridgeSpec,KafkaBridgeSpecBuilder>{
  public KafkaBridgeSpecBuilder() {
    this(new KafkaBridgeSpec());
  }
  
  public KafkaBridgeSpecBuilder(KafkaBridgeSpecFluent<?> fluent) {
    this(fluent, new KafkaBridgeSpec());
  }
  
  public KafkaBridgeSpecBuilder(KafkaBridgeSpecFluent<?> fluent,KafkaBridgeSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaBridgeSpecBuilder(KafkaBridgeSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaBridgeSpecFluent<?> fluent;
  
  public KafkaBridgeSpec build() {
    KafkaBridgeSpec buildable = new KafkaBridgeSpec();
    buildable.setReplicas(fluent.getReplicas());
    buildable.setImage(fluent.getImage());
    buildable.setHttp(fluent.buildHttp());
    buildable.setBootstrapServers(fluent.getBootstrapServers());
    buildable.setTls(fluent.buildTls());
    buildable.setAuthentication(fluent.buildAuthentication());
    buildable.setConsumer(fluent.buildConsumer());
    buildable.setProducer(fluent.buildProducer());
    buildable.setAdminClient(fluent.buildAdminClient());
    buildable.setResources(fluent.getResources());
    buildable.setJvmOptions(fluent.buildJvmOptions());
    buildable.setLogging(fluent.buildLogging());
    buildable.setEnableMetrics(fluent.isEnableMetrics());
    buildable.setLivenessProbe(fluent.buildLivenessProbe());
    buildable.setReadinessProbe(fluent.buildReadinessProbe());
    buildable.setTemplate(fluent.buildTemplate());
    buildable.setTracing(fluent.buildTracing());
    buildable.setClientRackInitImage(fluent.getClientRackInitImage());
    buildable.setRack(fluent.buildRack());
    return buildable;
  }
  

}