package io.strimzi.api.kafka.model.bridge;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaBridgeProducerSpecBuilder extends KafkaBridgeProducerSpecFluent<KafkaBridgeProducerSpecBuilder> implements VisitableBuilder<KafkaBridgeProducerSpec,KafkaBridgeProducerSpecBuilder>{
  public KafkaBridgeProducerSpecBuilder() {
    this(new KafkaBridgeProducerSpec());
  }
  
  public KafkaBridgeProducerSpecBuilder(KafkaBridgeProducerSpecFluent<?> fluent) {
    this(fluent, new KafkaBridgeProducerSpec());
  }
  
  public KafkaBridgeProducerSpecBuilder(KafkaBridgeProducerSpecFluent<?> fluent,KafkaBridgeProducerSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaBridgeProducerSpecBuilder(KafkaBridgeProducerSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaBridgeProducerSpecFluent<?> fluent;
  
  public KafkaBridgeProducerSpec build() {
    KafkaBridgeProducerSpec buildable = new KafkaBridgeProducerSpec();
    buildable.setEnabled(fluent.isEnabled());
    buildable.setConfig(fluent.getConfig());
    return buildable;
  }
  

}