package io.strimzi.api.kafka.model.bridge;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaBridgeHttpCorsBuilder extends KafkaBridgeHttpCorsFluent<KafkaBridgeHttpCorsBuilder> implements VisitableBuilder<KafkaBridgeHttpCors,KafkaBridgeHttpCorsBuilder>{
  public KafkaBridgeHttpCorsBuilder() {
    this(new KafkaBridgeHttpCors());
  }
  
  public KafkaBridgeHttpCorsBuilder(KafkaBridgeHttpCorsFluent<?> fluent) {
    this(fluent, new KafkaBridgeHttpCors());
  }
  
  public KafkaBridgeHttpCorsBuilder(KafkaBridgeHttpCorsFluent<?> fluent,KafkaBridgeHttpCors instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaBridgeHttpCorsBuilder(KafkaBridgeHttpCors instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaBridgeHttpCorsFluent<?> fluent;
  
  public KafkaBridgeHttpCors build() {
    KafkaBridgeHttpCors buildable = new KafkaBridgeHttpCors();
    buildable.setAllowedOrigins(fluent.getAllowedOrigins());
    buildable.setAllowedMethods(fluent.getAllowedMethods());
    return buildable;
  }
  

}