package io.strimzi.api.kafka.model.bridge;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaBridgeHttpConfigBuilder extends KafkaBridgeHttpConfigFluent<KafkaBridgeHttpConfigBuilder> implements VisitableBuilder<KafkaBridgeHttpConfig,KafkaBridgeHttpConfigBuilder>{
  public KafkaBridgeHttpConfigBuilder() {
    this(new KafkaBridgeHttpConfig());
  }
  
  public KafkaBridgeHttpConfigBuilder(KafkaBridgeHttpConfigFluent<?> fluent) {
    this(fluent, new KafkaBridgeHttpConfig());
  }
  
  public KafkaBridgeHttpConfigBuilder(KafkaBridgeHttpConfigFluent<?> fluent,KafkaBridgeHttpConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaBridgeHttpConfigBuilder(KafkaBridgeHttpConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaBridgeHttpConfigFluent<?> fluent;
  
  public KafkaBridgeHttpConfig build() {
    KafkaBridgeHttpConfig buildable = new KafkaBridgeHttpConfig(fluent.getPort());
    buildable.setCors(fluent.buildCors());
    return buildable;
  }
  

}