package io.strimzi.api.kafka.model.bridge;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaBridgeConsumerSpecBuilder extends KafkaBridgeConsumerSpecFluent<KafkaBridgeConsumerSpecBuilder> implements VisitableBuilder<KafkaBridgeConsumerSpec,KafkaBridgeConsumerSpecBuilder>{
  public KafkaBridgeConsumerSpecBuilder() {
    this(new KafkaBridgeConsumerSpec());
  }
  
  public KafkaBridgeConsumerSpecBuilder(KafkaBridgeConsumerSpecFluent<?> fluent) {
    this(fluent, new KafkaBridgeConsumerSpec());
  }
  
  public KafkaBridgeConsumerSpecBuilder(KafkaBridgeConsumerSpecFluent<?> fluent,KafkaBridgeConsumerSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaBridgeConsumerSpecBuilder(KafkaBridgeConsumerSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaBridgeConsumerSpecFluent<?> fluent;
  
  public KafkaBridgeConsumerSpec build() {
    KafkaBridgeConsumerSpec buildable = new KafkaBridgeConsumerSpec();
    buildable.setEnabled(fluent.isEnabled());
    buildable.setTimeoutSeconds(fluent.getTimeoutSeconds());
    buildable.setConfig(fluent.getConfig());
    return buildable;
  }
  

}