package io.strimzi.api.kafka.model.bridge;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KafkaBridgeClientSpecFluent<A extends KafkaBridgeClientSpecFluent<A>> extends BaseFluent<A>{
  public KafkaBridgeClientSpecFluent() {
  }
  
  public KafkaBridgeClientSpecFluent(KafkaBridgeClientSpec instance) {
    this.copyInstance(instance);
  }
  private Map<String,Object> config;
  
  protected void copyInstance(KafkaBridgeClientSpec instance) {
    if (instance != null) {
          this.withConfig(instance.getConfig());
        }
  }
  
  public A addToConfig(String key,Object value) {
    if(this.config == null && key != null && value != null) { this.config = new LinkedHashMap(); }
    if(key != null && value != null) {this.config.put(key, value);} return (A)this;
  }
  
  public A addToConfig(Map<String,Object> map) {
    if(this.config == null && map != null) { this.config = new LinkedHashMap(); }
    if(map != null) { this.config.putAll(map);} return (A)this;
  }
  
  public A removeFromConfig(String key) {
    if(this.config == null) { return (A) this; }
    if(key != null && this.config != null) {this.config.remove(key);} return (A)this;
  }
  
  public A removeFromConfig(Map<String,Object> map) {
    if(this.config == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.config != null){this.config.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getConfig() {
    return this.config;
  }
  
  public <K,V>A withConfig(Map<String,Object> config) {
    if (config == null) {
      this.config = null;
    } else {
      this.config = new LinkedHashMap(config);
    }
    return (A) this;
  }
  
  public boolean hasConfig() {
    return this.config != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaBridgeClientSpecFluent that = (KafkaBridgeClientSpecFluent) o;
    if (!java.util.Objects.equals(config, that.config)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(config,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (config != null && !config.isEmpty()) { sb.append("config:"); sb.append(config); }
    sb.append("}");
    return sb.toString();
  }
  

}