package io.strimzi.api.kafka.model.bridge;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaBridgeBuilder extends KafkaBridgeFluent<KafkaBridgeBuilder> implements VisitableBuilder<KafkaBridge,KafkaBridgeBuilder>{
  public KafkaBridgeBuilder() {
    this(new KafkaBridge());
  }
  
  public KafkaBridgeBuilder(KafkaBridgeFluent<?> fluent) {
    this(fluent, new KafkaBridge());
  }
  
  public KafkaBridgeBuilder(KafkaBridgeFluent<?> fluent,KafkaBridge instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaBridgeBuilder(KafkaBridge instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaBridgeFluent<?> fluent;
  
  public KafkaBridge build() {
    KafkaBridge buildable = new KafkaBridge(fluent.buildSpec(),fluent.buildStatus());
    buildable.setApiVersion(fluent.getApiVersion());
    buildable.setKind(fluent.getKind());
    buildable.setMetadata(fluent.buildMetadata());
    return buildable;
  }
  

}