package io.strimzi.api.kafka.model.bridge;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaBridgeAdminClientSpecBuilder extends KafkaBridgeAdminClientSpecFluent<KafkaBridgeAdminClientSpecBuilder> implements VisitableBuilder<KafkaBridgeAdminClientSpec,KafkaBridgeAdminClientSpecBuilder>{
  public KafkaBridgeAdminClientSpecBuilder() {
    this(new KafkaBridgeAdminClientSpec());
  }
  
  public KafkaBridgeAdminClientSpecBuilder(KafkaBridgeAdminClientSpecFluent<?> fluent) {
    this(fluent, new KafkaBridgeAdminClientSpec());
  }
  
  public KafkaBridgeAdminClientSpecBuilder(KafkaBridgeAdminClientSpecFluent<?> fluent,KafkaBridgeAdminClientSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaBridgeAdminClientSpecBuilder(KafkaBridgeAdminClientSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaBridgeAdminClientSpecFluent<?> fluent;
  
  public KafkaBridgeAdminClientSpec build() {
    KafkaBridgeAdminClientSpec buildable = new KafkaBridgeAdminClientSpec();
    buildable.setConfig(fluent.getConfig());
    return buildable;
  }
  

}