/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionCondition;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersion;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.strimzi.api.annotations.ApiVersion;
import io.strimzi.api.annotations.VersionRange;
import io.strimzi.api.kafka.model.AbstractCrdIT;
import io.strimzi.test.TestUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StructuralCrdIT
extends AbstractCrdIT {
    Map<String, String> crdFiles = Map.of("kafkas.kafka.strimzi.io", "040-Crd-kafka.yaml", "kafkaconnects.kafka.strimzi.io", "041-Crd-kafkaconnect.yaml", "kafkatopics.kafka.strimzi.io", "043-Crd-kafkatopic.yaml", "kafkausers.kafka.strimzi.io", "044-Crd-kafkauser.yaml", "kafkamirrormakers.kafka.strimzi.io", "045-Crd-kafkamirrormaker.yaml", "kafkabridges.kafka.strimzi.io", "046-Crd-kafkabridge.yaml", "kafkaconnectors.kafka.strimzi.io", "047-Crd-kafkaconnector.yaml", "kafkamirrormaker2s.kafka.strimzi.io", "048-Crd-kafkamirrormaker2.yaml", "kafkarebalances.kafka.strimzi.io", "049-Crd-kafkarebalance.yaml");

    @Test
    public void v1Beta2IsStructuralWithCrdV1() {
        this.assumeKube1_16Plus();
        for (Map.Entry<String, String> crd : this.crdFiles.entrySet()) {
            this.assertApiVersionsAreStructural(crd.getKey(), TestUtils.USER_PATH + "/../packaging/install/cluster-operator/" + crd.getValue(), (VersionRange<ApiVersion>)ApiVersion.parseRange((String)"v1beta2+"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertApiVersionsAreStructural(String api, String crdYaml, VersionRange<ApiVersion> shouldBeStructural) {
        this.cluster.createCustomResources(new String[]{crdYaml});
        try {
            this.cluster.waitForCustomResourceDefinition(api);
            this.assertApiVersionsAreStructuralInApiextensionsV1(api, shouldBeStructural);
        }
        catch (Throwable throwable) {
            this.cluster.deleteCustomResources(new String[]{crdYaml});
            throw throwable;
        }
        this.cluster.deleteCustomResources(new String[]{crdYaml});
    }

    private void assertApiVersionsAreStructuralInApiextensionsV1(String api, VersionRange<ApiVersion> shouldBeStructural) {
        Pattern pattern = Pattern.compile("[^.]spec\\.versions\\[([0-9]+)\\]\\.[^,]*?");
        CustomResourceDefinition crd = (CustomResourceDefinition)((Resource)this.cluster.client().getClient().apiextensions().v1().customResourceDefinitions().withName(api)).get();
        Set presentCrdApiVersions = crd.getSpec().getVersions().stream().map(v -> ApiVersion.parse((String)v.getName())).collect(Collectors.toSet());
        Assertions.assertTrue((boolean)presentCrdApiVersions.contains(shouldBeStructural.lower()), (String)("CRD has versions " + presentCrdApiVersions + " which doesn't include " + shouldBeStructural.lower() + " which should be structural"));
        HashMap<Integer, ApiVersion> indexedVersions = new HashMap<Integer, ApiVersion>();
        int i = 0;
        for (CustomResourceDefinitionVersion version : crd.getSpec().getVersions()) {
            indexedVersions.put(i, ApiVersion.parse((String)version.getName()));
        }
        Optional<CustomResourceDefinitionCondition> first = crd.getStatus().getConditions().stream().filter(cond -> "NonStructuralSchema".equals(cond.getType()) && "True".equals(cond.getStatus())).findFirst();
        if (first.isPresent()) {
            Matcher matcher = pattern.matcher(first.get().getMessage());
            while (matcher.find()) {
                Integer index = Integer.valueOf(matcher.group(1));
                ApiVersion nonStructuralVersion = (ApiVersion)indexedVersions.get(index);
                if (!shouldBeStructural.contains((Comparable)nonStructuralVersion)) continue;
                Assertions.fail((String)(api + "/ " + nonStructuralVersion + " should be structural but there's a complaint about " + matcher.group()));
            }
        }
    }
}

