/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.AbstractCrdIT;
import io.strimzi.api.kafka.model.KafkaUser;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.exceptions.KubeClusterException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class KafkaUserCrdIT
extends AbstractCrdIT {
    public static final String NAMESPACE = "kafkausercrd-it";

    @Test
    void testKafkaUserV1alpha1() {
        this.createDeleteCustomResource("KafkaUserV1alpha1.yaml");
    }

    @Test
    void testKafkaUserIsNotScaling() {
        Assertions.assertThrows(KubeClusterException.class, () -> this.createScaleDelete(KafkaUser.class, "KafkaUser.yaml"));
    }

    @Test
    void testKafkaUserV1beta1() {
        this.createDeleteCustomResource("KafkaUserV1beta1.yaml");
    }

    @Test
    void testKafkaUserMinimal() {
        this.createDeleteCustomResource("KafkaUser-minimal.yaml");
    }

    @Test
    void testKafkaUserWithExtraProperty() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.class, () -> this.createDeleteCustomResource("KafkaUser-with-extra-property.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.anyOf((Matcher)Matchers.containsString((String)"unknown field \"thisPropertyIsNotInTheSchema\""), (Matcher)Matchers.containsString((String)"unknown field \"spec.thisPropertyIsNotInTheSchema\"")));
    }

    @BeforeAll
    void setupEnvironment() {
        this.cluster.createCustomResources(new String[]{TestUtils.CRD_KAFKA_USER});
        this.cluster.waitForCustomResourceDefinition("kafkausers.kafka.strimzi.io");
        this.cluster.createNamespace(NAMESPACE);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @AfterAll
    void teardownEnvironment() {
        this.cluster.deleteCustomResources();
        this.cluster.deleteNamespaces();
    }
}

