/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.CustomResourceFluent;
import io.strimzi.api.kafka.model.AbstractCrdTest;
import io.strimzi.api.kafka.model.Kafka;
import io.strimzi.api.kafka.model.KafkaBuilder;
import io.strimzi.api.kafka.model.KafkaFluent;
import io.strimzi.api.kafka.model.KafkaSpecFluent;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder;
import io.strimzi.api.kafka.model.listener.arraylistener.KafkaListenerType;
import io.strimzi.api.kafka.model.status.Condition;
import io.strimzi.api.kafka.model.status.ConditionBuilder;
import io.strimzi.api.kafka.model.status.ListenerAddress;
import io.strimzi.api.kafka.model.status.ListenerAddressBuilder;
import io.strimzi.api.kafka.model.status.ListenerStatus;
import io.strimzi.api.kafka.model.status.ListenerStatusBuilder;
import io.strimzi.test.TestUtils;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;

public class KafkaTest
extends AbstractCrdTest<Kafka> {
    public KafkaTest() {
        super(Kafka.class);
    }

    @Test
    public void testCertificationAuthorityBuilderAndInts() throws URISyntaxException {
        List<GenericKafkaListener> listeners = Collections.singletonList(((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)new GenericKafkaListenerBuilder().withName("lst")).withPort(9092)).withType(KafkaListenerType.INTERNAL)).withTls(true)).build());
        Kafka kafka = ((KafkaBuilder)((KafkaFluent.SpecNested)((KafkaSpecFluent.ClusterCaNested)((KafkaFluent.SpecNested)((KafkaSpecFluent.ClientsCaNested)((KafkaFluent.SpecNested)((KafkaSpecFluent.EntityOperatorNested)((KafkaSpecFluent.EntityOperatorNested)((KafkaFluent.SpecNested)((KafkaSpecFluent.KafkaNested)((KafkaSpecFluent.KafkaNested)((KafkaSpecFluent.KafkaNested)((KafkaFluent.SpecNested)((KafkaSpecFluent.ZookeeperNested)((KafkaSpecFluent.ZookeeperNested)((KafkaBuilder)((CustomResourceFluent.MetadataNested)((CustomResourceFluent.MetadataNested)new KafkaBuilder().withNewMetadata().withName("my-cluster")).withNamespace("my-namespace")).endMetadata()).withNewSpec().withNewZookeeper().withReplicas(1)).withNewEphemeralStorage().endEphemeralStorage()).endZookeeper()).withNewKafka().withReplicas(1)).withListeners(listeners)).withNewEphemeralStorage().endEphemeralStorage()).endKafka()).withNewEntityOperator().withNewTopicOperator().endTopicOperator()).withNewUserOperator().endUserOperator()).endEntityOperator()).withNewClientsCa().withGenerateSecretOwnerReference(false)).endClientsCa()).withNewClusterCa().withGenerateSecretOwnerReference(false)).endClusterCa()).endSpec()).build();
        String path = Objects.requireNonNull(this.getClass().getResource("Kafka-ca-ints.yaml")).toURI().getPath();
        MatcherAssert.assertThat((Object)TestUtils.toYamlString((Object)kafka), (Matcher)CoreMatchers.is((Object)TestUtils.getFileAsString((String)path)));
    }

    @Test
    public void testNewListenerSerialization() throws URISyntaxException {
        List<GenericKafkaListener> listeners = Collections.singletonList(((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)new GenericKafkaListenerBuilder().withName("lst")).withPort(9092)).withType(KafkaListenerType.INTERNAL)).withTls(true)).build());
        Kafka kafka = ((KafkaBuilder)((KafkaFluent.SpecNested)((KafkaSpecFluent.EntityOperatorNested)((KafkaSpecFluent.EntityOperatorNested)((KafkaFluent.SpecNested)((KafkaSpecFluent.KafkaNested)((KafkaSpecFluent.KafkaNested)((KafkaSpecFluent.KafkaNested)((KafkaFluent.SpecNested)((KafkaSpecFluent.ZookeeperNested)((KafkaSpecFluent.ZookeeperNested)((KafkaBuilder)((CustomResourceFluent.MetadataNested)((CustomResourceFluent.MetadataNested)new KafkaBuilder().withNewMetadata().withName("my-cluster")).withNamespace("my-namespace")).endMetadata()).withNewSpec().withNewZookeeper().withReplicas(1)).withNewEphemeralStorage().endEphemeralStorage()).endZookeeper()).withNewKafka().withReplicas(1)).withListeners(listeners)).withNewEphemeralStorage().endEphemeralStorage()).endKafka()).withNewEntityOperator().withNewTopicOperator().endTopicOperator()).withNewUserOperator().endUserOperator()).endEntityOperator()).endSpec()).build();
        String path = Objects.requireNonNull(this.getClass().getResource("Kafka-new-listener-serialization.yaml")).toURI().getPath();
        MatcherAssert.assertThat((Object)TestUtils.toYamlString((Object)kafka), (Matcher)CoreMatchers.is((Object)TestUtils.getFileAsString((String)path)));
    }

    @Test
    public void testListeners() {
        Kafka model = (Kafka)TestUtils.fromYaml((String)"Kafka.yaml", Kafka.class);
        MatcherAssert.assertThat((Object)model.getSpec().getKafka().getListeners(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)model.getSpec().getKafka().getListeners().size(), (Matcher)CoreMatchers.is((Object)2));
        List listeners = model.getSpec().getKafka().getListeners();
        MatcherAssert.assertThat((Object)((GenericKafkaListener)listeners.get(0)).getAuth().getType(), (Matcher)CoreMatchers.is((Object)"scram-sha-512"));
        MatcherAssert.assertThat((Object)((GenericKafkaListener)listeners.get(1)).getAuth().getType(), (Matcher)CoreMatchers.is((Object)"tls"));
    }

    @Test
    public void testListenerTypeAndNameInStatus() throws ParseException, URISyntaxException {
        Kafka kafka = ((KafkaBuilder)((KafkaFluent.StatusNested)((KafkaFluent.StatusNested)((KafkaFluent.StatusNested)((KafkaBuilder)((KafkaFluent.SpecNested)((KafkaSpecFluent.ZookeeperNested)((KafkaSpecFluent.ZookeeperNested)((KafkaFluent.SpecNested)((KafkaSpecFluent.KafkaNested)((KafkaSpecFluent.KafkaNested)((KafkaSpecFluent.KafkaNested)((KafkaBuilder)((CustomResourceFluent.MetadataNested)((CustomResourceFluent.MetadataNested)((CustomResourceFluent.MetadataNested)new KafkaBuilder().withNewMetadata().withName("my-cluster")).withNamespace("my-namespace")).withGeneration(Long.valueOf(2L))).endMetadata()).withNewSpec().withNewKafka().withReplicas(3)).withListeners(new GenericKafkaListener[]{((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)new GenericKafkaListenerBuilder().withName("plain")).withPort(9092)).withType(KafkaListenerType.INTERNAL)).withTls(false)).build()})).withNewEphemeralStorage().endEphemeralStorage()).endKafka()).withNewZookeeper().withReplicas(3)).withNewEphemeralStorage().endEphemeralStorage()).endZookeeper()).endSpec()).withNewStatus().withObservedGeneration(1L)).withConditions(new Condition[]{((ConditionBuilder)((ConditionBuilder)new ConditionBuilder().withType("Ready")).withStatus("True")).build()})).withListeners(new ListenerStatus[]{((ListenerStatusBuilder)((ListenerStatusBuilder)new ListenerStatusBuilder().withName("plain")).withAddresses(new ListenerAddress[]{((ListenerAddressBuilder)((ListenerAddressBuilder)new ListenerAddressBuilder().withHost("my-service.my-namespace.svc")).withPort(Integer.valueOf(9092))).build()})).build(), ((ListenerStatusBuilder)((ListenerStatusBuilder)new ListenerStatusBuilder().withName("external")).withAddresses(new ListenerAddress[]{((ListenerAddressBuilder)((ListenerAddressBuilder)new ListenerAddressBuilder().withHost("my-route-address.domain.tld")).withPort(Integer.valueOf(443))).build()})).build()})).endStatus()).build();
        String path = Objects.requireNonNull(this.getClass().getResource("Kafka-listener-name-and-status.yaml")).toURI().getPath();
        MatcherAssert.assertThat((Object)TestUtils.toYamlString((Object)kafka), (Matcher)CoreMatchers.is((Object)TestUtils.getFileAsString((String)path)));
    }

    @Test
    public void testListenersTypeAndName() {
        Kafka model = (Kafka)TestUtils.fromYaml((String)"Kafka-listener-name-and-status.yaml", Kafka.class);
        MatcherAssert.assertThat((Object)model.getStatus().getListeners(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)model.getStatus().getListeners().size(), (Matcher)CoreMatchers.is((Object)2));
        List listeners = model.getStatus().getListeners();
        MatcherAssert.assertThat((Object)((ListenerStatus)listeners.get(0)).getType(), (Matcher)CoreMatchers.is((Object)"plain"));
        MatcherAssert.assertThat((Object)((ListenerStatus)listeners.get(1)).getType(), (Matcher)CoreMatchers.is((Object)"external"));
        MatcherAssert.assertThat((Object)((ListenerStatus)listeners.get(0)).getName(), (Matcher)CoreMatchers.is((Object)"plain"));
        MatcherAssert.assertThat((Object)((ListenerStatus)listeners.get(1)).getName(), (Matcher)CoreMatchers.is((Object)"external"));
    }

    public void rt(String resourceName) {
        Kafka model = (Kafka)TestUtils.fromYaml((String)(resourceName + ".yaml"), Kafka.class);
        MatcherAssert.assertThat((String)("The classpath resource " + resourceName + " does not exist"), (Object)model, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ObjectMeta metadata = model.getMetadata();
        MatcherAssert.assertThat((Object)metadata, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.assertDesiredResource(model, resourceName + ".out.yaml");
        this.assertDesiredResource((Kafka)TestUtils.fromYamlString((String)TestUtils.toYamlString((Object)model), Kafka.class), resourceName + ".out.yaml");
    }
}

