/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.AbstractCrdIT;
import io.strimzi.api.kafka.model.KafkaRebalance;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.exceptions.KubeClusterException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class KafkaRebalanceCrdIT
extends AbstractCrdIT {
    public static final String NAMESPACE = "kafkarebalance-crd-it";

    @Test
    void testKafkaRebalanceIsNotScaling() {
        Assertions.assertThrows(KubeClusterException.class, () -> this.createScaleDelete(KafkaRebalance.class, "KafkaRebalance.yaml"));
    }

    @Test
    void testKafkaRebalanceMinimal() {
        this.createDeleteCustomResource("KafkaRebalance-minimal.yaml");
    }

    @Test
    void testKafkaRebalanceWithGoals() {
        this.createDeleteCustomResource("KafkaRebalance-with-goals.yaml");
    }

    @Test
    void testKafkaRebalanceWithGoalsSkipHardGoalCheck() {
        this.createDeleteCustomResource("KafkaRebalance-with-goals-skip-hard-goal-check.yaml");
    }

    @Test
    void testKafkaRebalanceWithPerformanceTuning() {
        this.createDeleteCustomResource("KafkaRebalance-performance-tuning.yaml");
    }

    @Test
    void testKafkaRebalanceWithExcludedTopics() {
        this.createDeleteCustomResource("KafkaRebalance-excluded-topics.yaml");
    }

    @Test
    void testKafkaRebalanceAddBroker() {
        this.createDeleteCustomResource("KafkaRebalance-add-brokers.yaml");
    }

    @Test
    void testKafkaRebalanceRemoveBroker() {
        this.createDeleteCustomResource("KafkaRebalance-remove-brokers.yaml");
    }

    @Test
    void testKafkaRebalanceWrongMode() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.class, () -> this.createDeleteCustomResource("KafkaRebalance-wrong-mode.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"spec.mode: Unsupported value: \"wrong-mode\": supported values: \"full\", \"add-brokers\", \"remove-brokers\""));
    }

    @BeforeAll
    void setupEnvironment() {
        this.cluster.createCustomResources(new String[]{TestUtils.CRD_KAFKA_REBALANCE});
        this.cluster.waitForCustomResourceDefinition("kafkarebalances.kafka.strimzi.io");
        this.cluster.createNamespace(NAMESPACE);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @AfterAll
    void teardownEnvironment() {
        this.cluster.deleteCustomResources();
        this.cluster.deleteNamespaces();
    }
}

