/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.AbstractCrdIT;
import io.strimzi.api.kafka.model.KafkaMirrorMaker2;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.exceptions.KubeClusterException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class KafkaMirrorMaker2CrdIT
extends AbstractCrdIT {
    public static final String NAMESPACE = "kafkamirrormaker2-crd-it";

    @Test
    void testKafkaMirrorMaker2Scaling() {
        this.createScaleDelete(KafkaMirrorMaker2.class, "KafkaMirrorMaker2.yaml");
    }

    @Test
    void testKafkaMirrorMaker2Minimal() {
        this.createDeleteCustomResource("KafkaMirrorMaker2-minimal.yaml");
    }

    @Test
    void testKafkaMirrorMaker2WithExtraProperty() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.class, () -> this.createDeleteCustomResource("KafkaMirrorMaker2-with-extra-property.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"unknown field \"extra\""));
    }

    @Test
    void testKafkaMirrorMaker2WithMissingRequired() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.class, () -> this.createDeleteCustomResource("KafkaMirrorMaker2-with-missing-required-property.yaml"));
        this.assertMissingRequiredPropertiesMessage(exception.getMessage(), "connectCluster", "clusters.alias", "sourceCluster", "targetCluster");
    }

    @Test
    void testKafkaMirrorMaker2WithInvalidReplicas() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.class, () -> this.createDeleteCustomResource("KafkaMirrorMaker2-with-invalid-replicas.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.containsStringIgnoringCase((String)"Invalid value: \"string\": spec.replicas in body must be of type integer: \"string\""), CoreMatchers.containsStringIgnoringCase((String)"invalid type for io.strimzi.kafka.v1beta2.KafkaMirrorMaker2.spec.replicas: got \"string\", expected \"integer\"")}));
    }

    @Test
    void testKafkaMirrorMaker2WithTls() {
        this.createDeleteCustomResource("KafkaMirrorMaker2-with-tls.yaml");
    }

    @Test
    void testKafkaMirrorMaker2WithTlsAuth() {
        this.createDeleteCustomResource("KafkaMirrorMaker2-with-tls-auth.yaml");
    }

    @Test
    void testKafkaMirrorMaker2WithTlsAuthWithMissingRequired() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.class, () -> this.createDeleteCustomResource("KafkaMirrorMaker2-with-tls-auth-with-missing-required.yaml"));
        this.assertMissingRequiredPropertiesMessage(exception.getMessage(), "certificate", "key");
    }

    @Test
    void testKafkaMirrorMaker2WithScramSha512Auth() {
        this.createDeleteCustomResource("KafkaMirrorMaker2-with-scram-sha-512-auth.yaml");
    }

    @Test
    public void testKafkaMirrorMaker2WithTemplate() {
        this.createDeleteCustomResource("KafkaMirrorMaker2-with-template.yaml");
    }

    @Test
    public void testKafkaMirrorMaker2WithExternalConfiguration() {
        this.createDeleteCustomResource("KafkaMirrorMaker2-with-external-configuration.yaml");
    }

    @Test
    public void testKafkaMirrorMaker2WithInvalidExternalConfiguration() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.class, () -> this.createDeleteCustomResource("KafkaMirrorMaker2-with-invalid-external-configuration.yaml"));
        this.assertMissingRequiredPropertiesMessage(exception.getMessage(), "valueFrom");
    }

    @BeforeAll
    void setupEnvironment() {
        this.cluster.createCustomResources(new String[]{TestUtils.CRD_KAFKA_MIRROR_MAKER_2});
        this.cluster.waitForCustomResourceDefinition("kafkamirrormaker2s.kafka.strimzi.io");
        this.cluster.createNamespace(NAMESPACE);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @AfterAll
    void teardownEnvironment() {
        this.cluster.deleteCustomResources();
        this.cluster.deleteNamespaces();
    }
}

