/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.AbstractCrdIT;
import io.strimzi.api.kafka.model.Kafka;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.exceptions.KubeClusterException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class KafkaCrdIT
extends AbstractCrdIT {
    public static final String NAMESPACE = "kafkacrd-it";

    @Test
    void testKafkaIsNotScaling() {
        Assertions.assertThrows(KubeClusterException.class, () -> this.createScaleDelete(Kafka.class, "Kafka.yaml"));
    }

    @Test
    void testKafkaMinimal() {
        this.createDeleteCustomResource("Kafka-minimal.yaml");
    }

    @Test
    void testKafkaWithExtraProperty() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.class, () -> this.createDeleteCustomResource("Kafka-with-extra-property.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Matchers.containsString((String)"unknown field \"thisPropertyIsNotInTheSchema\""), Matchers.containsString((String)"unknown field \"spec.thisPropertyIsNotInTheSchema\"")}));
    }

    @Test
    void testKafkaWithMissingRequired() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.class, () -> this.createDeleteCustomResource("Kafka-with-missing-required-property.yaml"));
        this.assertMissingRequiredPropertiesMessage(exception.getMessage(), "zookeeper", "kafka");
    }

    @Test
    public void testKafkaWithEntityOperator() {
        this.createDeleteCustomResource("Kafka-with-entity-operator.yaml");
    }

    @Test
    public void testKafkaWithMaintenance() {
        this.createDeleteCustomResource("Kafka-with-maintenance.yaml");
    }

    @Test
    public void testKafkaWithNullMaintenance() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.class, () -> this.createDeleteCustomResource("Kafka-with-null-maintenance.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Matchers.containsStringIgnoringCase((String)"invalid: spec.maintenanceTimeWindows: Invalid value: \"null\": spec.maintenanceTimeWindows in body must be of type string: \"null\""), Matchers.containsStringIgnoringCase((String)"invalid: spec.maintenanceTimeWindows[0]: Invalid value: \"null\": spec.maintenanceTimeWindows[0] in body must be of type string: \"null\""), Matchers.containsStringIgnoringCase((String)"unknown object type \"nil\" in Kafka.spec.maintenanceTimeWindows[0]")}));
    }

    @Test
    public void testKafkaWithTemplate() {
        this.createDeleteCustomResource("Kafka-with-template.yaml");
    }

    @Test
    public void testKafkaWithJbodStorage() {
        this.createDeleteCustomResource("Kafka-with-jbod-storage.yaml");
    }

    @Test
    public void testKafkaWithJbodStorageOnZookeeper() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.class, () -> this.createDeleteCustomResource("Kafka-with-jbod-storage-on-zookeeper.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Matchers.containsStringIgnoringCase((String)"spec.zookeeper.storage.type in body should be one of [ephemeral persistent-claim]"), Matchers.containsStringIgnoringCase((String)"spec.zookeeper.storage.type: Unsupported value: \"jbod\": supported values: \"ephemeral\", \"persistent-claim\""), Matchers.containsStringIgnoringCase((String)"unknown field \"volumes\" in io.strimzi.kafka.v1beta2.Kafka.spec.zookeeper.storage"), Matchers.containsStringIgnoringCase((String)"unknown field \"spec.zookeeper.storage.volumes\"")}));
    }

    @Test
    public void testKafkaWithInvalidStorage() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.class, () -> this.createDeleteCustomResource("Kafka-with-invalid-storage.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Matchers.containsStringIgnoringCase((String)"spec.kafka.storage.type in body should be one of [ephemeral persistent-claim jbod]"), Matchers.containsStringIgnoringCase((String)"spec.kafka.storage.type: Unsupported value: \"foobar\": supported values: \"ephemeral\", \"persistent-claim\", \"jbod\"")}));
    }

    @Test
    public void testKafkaWithInvalidJmxAuthentication() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.class, () -> this.createDeleteCustomResource("Kafka-with-invalid-jmx-authentication.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Matchers.containsStringIgnoringCase((String)"spec.kafka.jmxOptions.authentication.type in body should be one of [password]"), Matchers.containsStringIgnoringCase((String)"spec.kafka.jmxOptions.authentication.type: Unsupported value: \"not-right\": supported values: \"password\"")}));
    }

    @Test
    public void testKafkaWithInvalidZookeeperJmxAuthentication() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.class, () -> this.createDeleteCustomResource("Kafka-with-invalid-zookeeper-jmx-authentication.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Matchers.containsStringIgnoringCase((String)"spec.zookeeper.jmxOptions.authentication.type in body should be one of [password]"), Matchers.containsStringIgnoringCase((String)"spec.zookeeper.jmxOptions.authentication.type: Unsupported value: \"not-right\": supported values: \"password\"")}));
    }

    @Test
    void testJmxOptionsWithoutRequiredOutputDefinitionKeys() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.class, () -> this.createDeleteCustomResource("JmxTrans-output-definition-with-missing-required-property.yaml"));
        this.assertMissingRequiredPropertiesMessage(exception.getMessage(), "outputType", "name");
    }

    @Test
    void testJmxOptionsWithoutRequiredQueryKeys() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.class, () -> this.createDeleteCustomResource("JmxTrans-queries-with-missing-required-property.yaml"));
        this.assertMissingRequiredPropertiesMessage(exception.getMessage(), "attributes", "outputs");
    }

    @BeforeAll
    void setupEnvironment() {
        this.cluster.createNamespace(NAMESPACE);
        this.cluster.createCustomResources(new String[]{TestUtils.CRD_KAFKA});
        this.cluster.waitForCustomResourceDefinition("kafkas.kafka.strimzi.io");
    }

    @AfterAll
    void teardownEnvironment() {
        this.cluster.deleteCustomResources(new String[]{TestUtils.CRD_KAFKA});
        this.cluster.deleteNamespaces();
    }
}

