/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.client.CustomResourceFluent;
import io.strimzi.api.kafka.model.CustomResourceConditions;
import io.strimzi.api.kafka.model.Kafka;
import io.strimzi.api.kafka.model.KafkaBridge;
import io.strimzi.api.kafka.model.KafkaBridgeBuilder;
import io.strimzi.api.kafka.model.KafkaBridgeFluent;
import io.strimzi.api.kafka.model.KafkaBuilder;
import io.strimzi.api.kafka.model.KafkaConnect;
import io.strimzi.api.kafka.model.KafkaConnectBuilder;
import io.strimzi.api.kafka.model.KafkaConnectFluent;
import io.strimzi.api.kafka.model.KafkaConnector;
import io.strimzi.api.kafka.model.KafkaConnectorBuilder;
import io.strimzi.api.kafka.model.KafkaConnectorFluent;
import io.strimzi.api.kafka.model.KafkaFluent;
import io.strimzi.api.kafka.model.KafkaMirrorMaker2;
import io.strimzi.api.kafka.model.KafkaMirrorMaker2Builder;
import io.strimzi.api.kafka.model.KafkaMirrorMaker2Fluent;
import io.strimzi.api.kafka.model.KafkaRebalance;
import io.strimzi.api.kafka.model.KafkaRebalanceBuilder;
import io.strimzi.api.kafka.model.KafkaRebalanceFluent;
import io.strimzi.api.kafka.model.KafkaTopic;
import io.strimzi.api.kafka.model.KafkaTopicBuilder;
import io.strimzi.api.kafka.model.KafkaTopicFluent;
import io.strimzi.api.kafka.model.KafkaUser;
import io.strimzi.api.kafka.model.KafkaUserBuilder;
import io.strimzi.api.kafka.model.KafkaUserFluent;
import io.strimzi.api.kafka.model.balancing.KafkaRebalanceState;
import io.strimzi.api.kafka.model.status.StatusFluent;
import java.util.function.Predicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CustomResourceConditionsTest {
    Predicate<Kafka> kafkaIsReady = CustomResourceConditions.isReady();
    Predicate<KafkaRebalance> customConditionPresent = CustomResourceConditions.isLatestGenerationAndAnyConditionMatches((String)"ProposalReady", (String)"True");

    CustomResourceConditionsTest() {
    }

    @Test
    public void testIsReady_EmptyCrdIsNotReady() {
        Kafka emptyKafka = new KafkaBuilder().build();
        Assertions.assertFalse((boolean)this.kafkaIsReady.test(emptyKafka));
    }

    @Test
    public void testIsReady_ReadyKafka() {
        Kafka build = ((KafkaBuilder)((KafkaFluent.StatusNested)((StatusFluent.ConditionsNested)((StatusFluent.ConditionsNested)((KafkaFluent.StatusNested)((KafkaBuilder)((CustomResourceFluent.MetadataNested)new KafkaBuilder().editMetadata().withGeneration(Long.valueOf(2L))).endMetadata()).withNewStatus().withObservedGeneration(2L)).addNewCondition().withType("Ready")).withStatus("True")).endCondition()).endStatus()).build();
        Assertions.assertTrue((boolean)this.kafkaIsReady.test(build));
    }

    @Test
    public void testIsReady_ConditionMissing() {
        Kafka build = ((KafkaBuilder)((KafkaFluent.StatusNested)((KafkaBuilder)((CustomResourceFluent.MetadataNested)new KafkaBuilder().editMetadata().withGeneration(Long.valueOf(2L))).endMetadata()).withNewStatus().withObservedGeneration(2L)).endStatus()).build();
        Assertions.assertFalse((boolean)this.kafkaIsReady.test(build));
    }

    @Test
    public void testIsReady_ConditionNotTrue() {
        Kafka build = ((KafkaBuilder)((KafkaFluent.StatusNested)((StatusFluent.ConditionsNested)((StatusFluent.ConditionsNested)((KafkaFluent.StatusNested)((KafkaBuilder)((CustomResourceFluent.MetadataNested)new KafkaBuilder().editMetadata().withGeneration(Long.valueOf(2L))).endMetadata()).withNewStatus().withObservedGeneration(2L)).addNewCondition().withType("Ready")).withStatus("False")).endCondition()).endStatus()).build();
        Assertions.assertFalse((boolean)this.kafkaIsReady.test(build));
    }

    @Test
    public void testIsReady_NullStatus() {
        Kafka build = ((KafkaBuilder)((CustomResourceFluent.MetadataNested)new KafkaBuilder().editMetadata().withGeneration(Long.valueOf(2L))).endMetadata()).build();
        Assertions.assertFalse((boolean)this.kafkaIsReady.test(build));
    }

    @Test
    public void testIsReady_ObservedGenerationNotEqualToMetadataGeneration() {
        Kafka build = ((KafkaBuilder)((KafkaFluent.StatusNested)((StatusFluent.ConditionsNested)((StatusFluent.ConditionsNested)((KafkaFluent.StatusNested)((KafkaBuilder)((CustomResourceFluent.MetadataNested)new KafkaBuilder().editMetadata().withGeneration(Long.valueOf(2L))).endMetadata()).withNewStatus().withObservedGeneration(1L)).addNewCondition().withType("Ready")).withStatus("True")).endCondition()).endStatus()).build();
        Assertions.assertFalse((boolean)this.kafkaIsReady.test(build));
    }

    @Test
    public void testIsLatestGenerationAndAnyConditionMatches_EmptyCrd() {
        KafkaRebalance build = new KafkaRebalanceBuilder().build();
        Assertions.assertFalse((boolean)this.customConditionPresent.test(build));
    }

    @Test
    public void testIsLatestGenerationAndAnyConditionMatches_ReadyProposal() {
        KafkaRebalance build = ((KafkaRebalanceBuilder)((KafkaRebalanceFluent.StatusNested)((StatusFluent.ConditionsNested)((StatusFluent.ConditionsNested)((KafkaRebalanceFluent.StatusNested)((KafkaRebalanceBuilder)((CustomResourceFluent.MetadataNested)new KafkaRebalanceBuilder().editMetadata().withGeneration(Long.valueOf(2L))).endMetadata()).withNewStatus().withObservedGeneration(2L)).addNewCondition().withType("ProposalReady")).withStatus("True")).endCondition()).endStatus()).build();
        Assertions.assertTrue((boolean)this.customConditionPresent.test(build));
    }

    @Test
    public void testIsLatestGenerationAndAnyConditionMatches_ConditionMissing() {
        KafkaRebalance build = ((KafkaRebalanceBuilder)((KafkaRebalanceFluent.StatusNested)((KafkaRebalanceBuilder)((CustomResourceFluent.MetadataNested)new KafkaRebalanceBuilder().editMetadata().withGeneration(Long.valueOf(2L))).endMetadata()).withNewStatus().withObservedGeneration(2L)).endStatus()).build();
        Assertions.assertFalse((boolean)this.customConditionPresent.test(build));
    }

    @Test
    public void testIsLatestGenerationAndAnyConditionMatches_ConditionNotTrue() {
        KafkaRebalance build = ((KafkaRebalanceBuilder)((KafkaRebalanceFluent.StatusNested)((StatusFluent.ConditionsNested)((StatusFluent.ConditionsNested)((KafkaRebalanceFluent.StatusNested)((KafkaRebalanceBuilder)((CustomResourceFluent.MetadataNested)new KafkaRebalanceBuilder().editMetadata().withGeneration(Long.valueOf(2L))).endMetadata()).withNewStatus().withObservedGeneration(2L)).addNewCondition().withType("ProposalReady")).withStatus("False")).endCondition()).endStatus()).build();
        Assertions.assertFalse((boolean)this.customConditionPresent.test(build));
    }

    @Test
    public void testIsLatestGenerationAndAnyConditionMatches_NullStatus() {
        KafkaRebalance build = ((KafkaRebalanceBuilder)((CustomResourceFluent.MetadataNested)new KafkaRebalanceBuilder().editMetadata().withGeneration(Long.valueOf(2L))).endMetadata()).build();
        Assertions.assertFalse((boolean)this.customConditionPresent.test(build));
    }

    @Test
    public void testIsLatestGenerationAndAnyConditionMatches_ObservedGenerationNotEqualToMetadataGeneration() {
        KafkaRebalance build = ((KafkaRebalanceBuilder)((KafkaRebalanceFluent.StatusNested)((StatusFluent.ConditionsNested)((StatusFluent.ConditionsNested)((KafkaRebalanceFluent.StatusNested)((KafkaRebalanceBuilder)((CustomResourceFluent.MetadataNested)new KafkaRebalanceBuilder().editMetadata().withGeneration(Long.valueOf(2L))).endMetadata()).withNewStatus().withObservedGeneration(1L)).addNewCondition().withType("ProposalReady")).withStatus("True")).endCondition()).endStatus()).build();
        Assertions.assertFalse((boolean)this.customConditionPresent.test(build));
    }

    @Test
    public void testKafkaIsReady() {
        Kafka build = ((KafkaBuilder)((KafkaFluent.StatusNested)((StatusFluent.ConditionsNested)((StatusFluent.ConditionsNested)((KafkaFluent.StatusNested)((KafkaBuilder)((CustomResourceFluent.MetadataNested)new KafkaBuilder().editMetadata().withGeneration(Long.valueOf(2L))).endMetadata()).withNewStatus().withObservedGeneration(2L)).addNewCondition().withType("Ready")).withStatus("True")).endCondition()).endStatus()).build();
        Assertions.assertTrue((boolean)Kafka.isReady().test(build));
    }

    @Test
    public void testKafkaConnectorIsReady() {
        KafkaConnector build = ((KafkaConnectorBuilder)((KafkaConnectorFluent.StatusNested)((StatusFluent.ConditionsNested)((StatusFluent.ConditionsNested)((KafkaConnectorFluent.StatusNested)((KafkaConnectorBuilder)((CustomResourceFluent.MetadataNested)new KafkaConnectorBuilder().editMetadata().withGeneration(Long.valueOf(2L))).endMetadata()).withNewStatus().withObservedGeneration(2L)).addNewCondition().withType("Ready")).withStatus("True")).endCondition()).endStatus()).build();
        Assertions.assertTrue((boolean)KafkaConnector.isReady().test(build));
    }

    @Test
    public void testKafkaConnectIsReady() {
        KafkaConnect build = ((KafkaConnectBuilder)((KafkaConnectFluent.StatusNested)((StatusFluent.ConditionsNested)((StatusFluent.ConditionsNested)((KafkaConnectFluent.StatusNested)((KafkaConnectBuilder)((CustomResourceFluent.MetadataNested)new KafkaConnectBuilder().editMetadata().withGeneration(Long.valueOf(2L))).endMetadata()).withNewStatus().withObservedGeneration(2L)).addNewCondition().withType("Ready")).withStatus("True")).endCondition()).endStatus()).build();
        Assertions.assertTrue((boolean)KafkaConnect.isReady().test(build));
    }

    @Test
    public void testKafkaTopicIsReady() {
        KafkaTopic build = ((KafkaTopicBuilder)((KafkaTopicFluent.StatusNested)((StatusFluent.ConditionsNested)((StatusFluent.ConditionsNested)((KafkaTopicFluent.StatusNested)((KafkaTopicBuilder)((CustomResourceFluent.MetadataNested)new KafkaTopicBuilder().editMetadata().withGeneration(Long.valueOf(2L))).endMetadata()).withNewStatus().withObservedGeneration(2L)).addNewCondition().withType("Ready")).withStatus("True")).endCondition()).endStatus()).build();
        Assertions.assertTrue((boolean)KafkaTopic.isReady().test(build));
    }

    @Test
    public void testKafkaBridgeIsReady() {
        KafkaBridge build = ((KafkaBridgeBuilder)((KafkaBridgeFluent.StatusNested)((StatusFluent.ConditionsNested)((StatusFluent.ConditionsNested)((KafkaBridgeFluent.StatusNested)((KafkaBridgeBuilder)((CustomResourceFluent.MetadataNested)new KafkaBridgeBuilder().editMetadata().withGeneration(Long.valueOf(2L))).endMetadata()).withNewStatus().withObservedGeneration(2L)).addNewCondition().withType("Ready")).withStatus("True")).endCondition()).endStatus()).build();
        Assertions.assertTrue((boolean)KafkaBridge.isReady().test(build));
    }

    @Test
    public void testKafkaMirrorMaker2IsReady() {
        KafkaMirrorMaker2 build = ((KafkaMirrorMaker2Builder)((KafkaMirrorMaker2Fluent.StatusNested)((StatusFluent.ConditionsNested)((StatusFluent.ConditionsNested)((KafkaMirrorMaker2Fluent.StatusNested)((KafkaMirrorMaker2Builder)((CustomResourceFluent.MetadataNested)new KafkaMirrorMaker2Builder().editMetadata().withGeneration(Long.valueOf(2L))).endMetadata()).withNewStatus().withObservedGeneration(2L)).addNewCondition().withType("Ready")).withStatus("True")).endCondition()).endStatus()).build();
        Assertions.assertTrue((boolean)KafkaMirrorMaker2.isReady().test(build));
    }

    @Test
    public void testKafkaUserIsReady() {
        KafkaUser build = ((KafkaUserBuilder)((KafkaUserFluent.StatusNested)((StatusFluent.ConditionsNested)((StatusFluent.ConditionsNested)((KafkaUserFluent.StatusNested)((KafkaUserBuilder)((CustomResourceFluent.MetadataNested)new KafkaUserBuilder().editMetadata().withGeneration(Long.valueOf(2L))).endMetadata()).withNewStatus().withObservedGeneration(2L)).addNewCondition().withType("Ready")).withStatus("True")).endCondition()).endStatus()).build();
        Assertions.assertTrue((boolean)KafkaUser.isReady().test(build));
    }

    @Test
    public void testKafkaRebalanceIsState() {
        for (KafkaRebalanceState crdState : KafkaRebalanceState.values()) {
            KafkaRebalance build = ((KafkaRebalanceBuilder)((KafkaRebalanceFluent.StatusNested)((StatusFluent.ConditionsNested)((StatusFluent.ConditionsNested)((KafkaRebalanceFluent.StatusNested)((KafkaRebalanceBuilder)((CustomResourceFluent.MetadataNested)new KafkaRebalanceBuilder().editMetadata().withGeneration(Long.valueOf(2L))).endMetadata()).withNewStatus().withObservedGeneration(2L)).addNewCondition().withType(crdState.name())).withStatus("True")).endCondition()).endStatus()).build();
            for (KafkaRebalanceState testState : KafkaRebalanceState.values()) {
                Assertions.assertEquals((Object)KafkaRebalance.isInState((KafkaRebalanceState)testState).test(build), (Object)(testState == crdState ? 1 : 0));
            }
        }
    }
}

