/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.CustomResource;
import io.strimzi.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractCrdTest<R extends CustomResource> {
    private final Class<R> crdClass;

    protected AbstractCrdTest(Class<R> crdClass) {
        this.crdClass = crdClass;
        Assertions.assertDoesNotThrow(() -> ((CustomResource)crdClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).getKind());
    }

    protected void assertDesiredResource(R actual, String expectedResource) {
        String content = TestUtils.readResource(this.getClass(), (String)expectedResource);
        MatcherAssert.assertThat((String)("The resource " + expectedResource + " does not exist"), (Object)content, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        String ssStr = TestUtils.toYamlString(actual);
        MatcherAssert.assertThat((Object)ssStr.trim(), (Matcher)CoreMatchers.is((Object)content.trim()));
    }

    @Test
    public void roundTrip() {
        String resourceName = this.crdClass.getSimpleName() + ".yaml";
        CustomResource model = (CustomResource)TestUtils.fromYaml((String)resourceName, this.crdClass);
        MatcherAssert.assertThat((String)("The classpath resource " + resourceName + " does not exist"), (Object)model, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ObjectMeta metadata = model.getMetadata();
        MatcherAssert.assertThat((Object)metadata, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.assertDesiredResource(model, this.crdClass.getSimpleName() + ".out.yaml");
        this.assertDesiredResource((CustomResource)TestUtils.fromYamlString((String)TestUtils.toYamlString((Object)model), this.crdClass), this.crdClass.getSimpleName() + ".out.yaml");
    }
}

