/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.template.ExternalServiceTemplate;
import io.strimzi.api.kafka.model.template.ExternalServiceTemplateFluent;
import io.strimzi.api.kafka.model.template.ExternalTrafficPolicy;
import io.strimzi.api.kafka.model.template.MetadataTemplate;
import io.strimzi.api.kafka.model.template.MetadataTemplateBuilder;
import io.strimzi.api.kafka.model.template.MetadataTemplateFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ExternalServiceTemplateFluentImpl<A extends ExternalServiceTemplateFluent<A>>
extends BaseFluent<A>
implements ExternalServiceTemplateFluent<A> {
    private MetadataTemplateBuilder metadata;
    private ExternalTrafficPolicy externalTrafficPolicy;
    private List<String> loadBalancerSourceRanges;

    public ExternalServiceTemplateFluentImpl() {
    }

    public ExternalServiceTemplateFluentImpl(ExternalServiceTemplate instance) {
        this.withMetadata(instance.getMetadata());
        this.withExternalTrafficPolicy(instance.getExternalTrafficPolicy());
        this.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges());
    }

    @Override
    @Deprecated
    public MetadataTemplate getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public MetadataTemplate buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(MetadataTemplate metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new MetadataTemplateBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ExternalServiceTemplateFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ExternalServiceTemplateFluent.MetadataNested<A> withNewMetadataLike(MetadataTemplate item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ExternalServiceTemplateFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ExternalServiceTemplateFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new MetadataTemplateBuilder().build());
    }

    @Override
    public ExternalServiceTemplateFluent.MetadataNested<A> editOrNewMetadataLike(MetadataTemplate item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public ExternalTrafficPolicy getExternalTrafficPolicy() {
        return this.externalTrafficPolicy;
    }

    @Override
    public A withExternalTrafficPolicy(ExternalTrafficPolicy externalTrafficPolicy) {
        this.externalTrafficPolicy = externalTrafficPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasExternalTrafficPolicy() {
        return this.externalTrafficPolicy != null;
    }

    @Override
    public A addToLoadBalancerSourceRanges(int index, String item) {
        if (this.loadBalancerSourceRanges == null) {
            this.loadBalancerSourceRanges = new ArrayList<String>();
        }
        this.loadBalancerSourceRanges.add(index, item);
        return (A)this;
    }

    @Override
    public A setToLoadBalancerSourceRanges(int index, String item) {
        if (this.loadBalancerSourceRanges == null) {
            this.loadBalancerSourceRanges = new ArrayList<String>();
        }
        this.loadBalancerSourceRanges.set(index, item);
        return (A)this;
    }

    @Override
    public A addToLoadBalancerSourceRanges(String ... items) {
        if (this.loadBalancerSourceRanges == null) {
            this.loadBalancerSourceRanges = new ArrayList<String>();
        }
        for (String item : items) {
            this.loadBalancerSourceRanges.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToLoadBalancerSourceRanges(Collection<String> items) {
        if (this.loadBalancerSourceRanges == null) {
            this.loadBalancerSourceRanges = new ArrayList<String>();
        }
        for (String item : items) {
            this.loadBalancerSourceRanges.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromLoadBalancerSourceRanges(String ... items) {
        for (String item : items) {
            if (this.loadBalancerSourceRanges == null) continue;
            this.loadBalancerSourceRanges.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromLoadBalancerSourceRanges(Collection<String> items) {
        for (String item : items) {
            if (this.loadBalancerSourceRanges == null) continue;
            this.loadBalancerSourceRanges.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getLoadBalancerSourceRanges() {
        return this.loadBalancerSourceRanges;
    }

    @Override
    public String getLoadBalancerSourceRange(int index) {
        return this.loadBalancerSourceRanges.get(index);
    }

    @Override
    public String getFirstLoadBalancerSourceRange() {
        return this.loadBalancerSourceRanges.get(0);
    }

    @Override
    public String getLastLoadBalancerSourceRange() {
        return this.loadBalancerSourceRanges.get(this.loadBalancerSourceRanges.size() - 1);
    }

    @Override
    public String getMatchingLoadBalancerSourceRange(Predicate<String> predicate) {
        for (String item : this.loadBalancerSourceRanges) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingLoadBalancerSourceRange(Predicate<String> predicate) {
        for (String item : this.loadBalancerSourceRanges) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withLoadBalancerSourceRanges(List<String> loadBalancerSourceRanges) {
        if (this.loadBalancerSourceRanges != null) {
            this._visitables.get((Object)"loadBalancerSourceRanges").removeAll(this.loadBalancerSourceRanges);
        }
        if (loadBalancerSourceRanges != null) {
            this.loadBalancerSourceRanges = new ArrayList<String>();
            for (String item : loadBalancerSourceRanges) {
                this.addToLoadBalancerSourceRanges(item);
            }
        } else {
            this.loadBalancerSourceRanges = null;
        }
        return (A)this;
    }

    @Override
    public A withLoadBalancerSourceRanges(String ... loadBalancerSourceRanges) {
        if (this.loadBalancerSourceRanges != null) {
            this.loadBalancerSourceRanges.clear();
        }
        if (loadBalancerSourceRanges != null) {
            for (String item : loadBalancerSourceRanges) {
                this.addToLoadBalancerSourceRanges(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasLoadBalancerSourceRanges() {
        return this.loadBalancerSourceRanges != null && !this.loadBalancerSourceRanges.isEmpty();
    }

    @Override
    public A addNewLoadBalancerSourceRange(StringBuilder arg1) {
        return this.addToLoadBalancerSourceRanges(new String(arg1));
    }

    @Override
    public A addNewLoadBalancerSourceRange(int[] arg1, int arg2, int arg3) {
        return this.addToLoadBalancerSourceRanges(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewLoadBalancerSourceRange(char[] arg1) {
        return this.addToLoadBalancerSourceRanges(new String(arg1));
    }

    @Override
    public A addNewLoadBalancerSourceRange(StringBuffer arg1) {
        return this.addToLoadBalancerSourceRanges(new String(arg1));
    }

    @Override
    public A addNewLoadBalancerSourceRange(byte[] arg1, int arg2) {
        return this.addToLoadBalancerSourceRanges(new String(arg1, arg2));
    }

    @Override
    public A addNewLoadBalancerSourceRange(byte[] arg1) {
        return this.addToLoadBalancerSourceRanges(new String(arg1));
    }

    @Override
    public A addNewLoadBalancerSourceRange(char[] arg1, int arg2, int arg3) {
        return this.addToLoadBalancerSourceRanges(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewLoadBalancerSourceRange(byte[] arg1, int arg2, int arg3) {
        return this.addToLoadBalancerSourceRanges(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewLoadBalancerSourceRange(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.addToLoadBalancerSourceRanges(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A addNewLoadBalancerSourceRange(String arg1) {
        return this.addToLoadBalancerSourceRanges(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalServiceTemplateFluentImpl that = (ExternalServiceTemplateFluentImpl)o;
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.externalTrafficPolicy != null ? !this.externalTrafficPolicy.equals((Object)that.externalTrafficPolicy) : that.externalTrafficPolicy != null) {
            return false;
        }
        return !(this.loadBalancerSourceRanges != null ? !this.loadBalancerSourceRanges.equals(that.loadBalancerSourceRanges) : that.loadBalancerSourceRanges != null);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.metadata, this.externalTrafficPolicy, this.loadBalancerSourceRanges, super.hashCode()});
    }

    public class MetadataNestedImpl<N>
    extends MetadataTemplateFluentImpl<ExternalServiceTemplateFluent.MetadataNested<N>>
    implements ExternalServiceTemplateFluent.MetadataNested<N>,
    Nested<N> {
        private final MetadataTemplateBuilder builder;

        MetadataNestedImpl(MetadataTemplate item) {
            this.builder = new MetadataTemplateBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new MetadataTemplateBuilder(this);
        }

        @Override
        public N and() {
            return (N)ExternalServiceTemplateFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

