/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.status.KafkaUserStatus;
import io.strimzi.api.kafka.model.status.KafkaUserStatusFluent;
import io.strimzi.api.kafka.model.status.KafkaUserStatusFluentImpl;
import java.util.Objects;

public class KafkaUserStatusBuilder
extends KafkaUserStatusFluentImpl<KafkaUserStatusBuilder>
implements VisitableBuilder<KafkaUserStatus, KafkaUserStatusBuilder> {
    KafkaUserStatusFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaUserStatusBuilder() {
        this(true);
    }

    public KafkaUserStatusBuilder(Boolean validationEnabled) {
        this(new KafkaUserStatus(), validationEnabled);
    }

    public KafkaUserStatusBuilder(KafkaUserStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KafkaUserStatusBuilder(KafkaUserStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KafkaUserStatus(), validationEnabled);
    }

    public KafkaUserStatusBuilder(KafkaUserStatusFluent<?> fluent, KafkaUserStatus instance) {
        this(fluent, instance, true);
    }

    public KafkaUserStatusBuilder(KafkaUserStatusFluent<?> fluent, KafkaUserStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withUsername(instance.getUsername());
        fluent.withSecret(instance.getSecret());
        fluent.withConditions(instance.getConditions());
        fluent.withObservedGeneration(instance.getObservedGeneration());
        this.validationEnabled = validationEnabled;
    }

    public KafkaUserStatusBuilder(KafkaUserStatus instance) {
        this(instance, (Boolean)true);
    }

    public KafkaUserStatusBuilder(KafkaUserStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withUsername(instance.getUsername());
        this.withSecret(instance.getSecret());
        this.withConditions(instance.getConditions());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.validationEnabled = validationEnabled;
    }

    public KafkaUserStatus build() {
        KafkaUserStatus buildable = new KafkaUserStatus();
        buildable.setConditions(this.fluent.getConditions());
        buildable.setObservedGeneration(this.fluent.getObservedGeneration());
        buildable.setUsername(this.fluent.getUsername());
        buildable.setSecret(this.fluent.getSecret());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaUserStatusBuilder that = (KafkaUserStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

