/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.connect.ConnectorPlugin;
import io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder;
import io.strimzi.api.kafka.model.connect.ConnectorPluginFluentImpl;
import io.strimzi.api.kafka.model.status.KafkaConnectStatus;
import io.strimzi.api.kafka.model.status.KafkaConnectStatusFluent;
import io.strimzi.api.kafka.model.status.StatusFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class KafkaConnectStatusFluentImpl<A extends KafkaConnectStatusFluent<A>>
extends StatusFluentImpl<A>
implements KafkaConnectStatusFluent<A> {
    private String url;
    private List<ConnectorPluginBuilder> connectorPlugins;
    private int replicas;
    private String labelSelector;

    public KafkaConnectStatusFluentImpl() {
    }

    public KafkaConnectStatusFluentImpl(KafkaConnectStatus instance) {
        this.withUrl(instance.getUrl());
        this.withConnectorPlugins(instance.getConnectorPlugins());
        this.withReplicas(instance.getReplicas());
        this.withLabelSelector(instance.getLabelSelector());
        this.withConditions(instance.getConditions());
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public A withUrl(String url) {
        this.url = url;
        return (A)this;
    }

    @Override
    public Boolean hasUrl() {
        return this.url != null;
    }

    @Override
    public A withNewUrl(StringBuilder arg1) {
        return this.withUrl(new String(arg1));
    }

    @Override
    public A withNewUrl(int[] arg1, int arg2, int arg3) {
        return this.withUrl(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewUrl(char[] arg1) {
        return this.withUrl(new String(arg1));
    }

    @Override
    public A withNewUrl(StringBuffer arg1) {
        return this.withUrl(new String(arg1));
    }

    @Override
    public A withNewUrl(byte[] arg1, int arg2) {
        return this.withUrl(new String(arg1, arg2));
    }

    @Override
    public A withNewUrl(byte[] arg1) {
        return this.withUrl(new String(arg1));
    }

    @Override
    public A withNewUrl(char[] arg1, int arg2, int arg3) {
        return this.withUrl(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewUrl(byte[] arg1, int arg2, int arg3) {
        return this.withUrl(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewUrl(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.withUrl(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewUrl(String arg1) {
        return this.withUrl(new String(arg1));
    }

    @Override
    public A addToConnectorPlugins(int index, ConnectorPlugin item) {
        if (this.connectorPlugins == null) {
            this.connectorPlugins = new ArrayList<ConnectorPluginBuilder>();
        }
        ConnectorPluginBuilder builder = new ConnectorPluginBuilder(item);
        this._visitables.get((Object)"connectorPlugins").add(index >= 0 ? index : this._visitables.get((Object)"connectorPlugins").size(), builder);
        this.connectorPlugins.add(index >= 0 ? index : this.connectorPlugins.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConnectorPlugins(int index, ConnectorPlugin item) {
        if (this.connectorPlugins == null) {
            this.connectorPlugins = new ArrayList<ConnectorPluginBuilder>();
        }
        ConnectorPluginBuilder builder = new ConnectorPluginBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"connectorPlugins").size()) {
            this._visitables.get((Object)"connectorPlugins").add(builder);
        } else {
            this._visitables.get((Object)"connectorPlugins").set(index, builder);
        }
        if (index < 0 || index >= this.connectorPlugins.size()) {
            this.connectorPlugins.add(builder);
        } else {
            this.connectorPlugins.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConnectorPlugins(ConnectorPlugin ... items) {
        if (this.connectorPlugins == null) {
            this.connectorPlugins = new ArrayList<ConnectorPluginBuilder>();
        }
        for (ConnectorPlugin item : items) {
            ConnectorPluginBuilder builder = new ConnectorPluginBuilder(item);
            this._visitables.get((Object)"connectorPlugins").add(builder);
            this.connectorPlugins.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConnectorPlugins(Collection<ConnectorPlugin> items) {
        if (this.connectorPlugins == null) {
            this.connectorPlugins = new ArrayList<ConnectorPluginBuilder>();
        }
        for (ConnectorPlugin item : items) {
            ConnectorPluginBuilder builder = new ConnectorPluginBuilder(item);
            this._visitables.get((Object)"connectorPlugins").add(builder);
            this.connectorPlugins.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConnectorPlugins(ConnectorPlugin ... items) {
        for (ConnectorPlugin item : items) {
            ConnectorPluginBuilder builder = new ConnectorPluginBuilder(item);
            this._visitables.get((Object)"connectorPlugins").remove(builder);
            if (this.connectorPlugins == null) continue;
            this.connectorPlugins.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConnectorPlugins(Collection<ConnectorPlugin> items) {
        for (ConnectorPlugin item : items) {
            ConnectorPluginBuilder builder = new ConnectorPluginBuilder(item);
            this._visitables.get((Object)"connectorPlugins").remove(builder);
            if (this.connectorPlugins == null) continue;
            this.connectorPlugins.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConnectorPlugins(Predicate<ConnectorPluginBuilder> predicate) {
        if (this.connectorPlugins == null) {
            return (A)this;
        }
        Iterator<ConnectorPluginBuilder> each = this.connectorPlugins.iterator();
        List visitables = this._visitables.get((Object)"connectorPlugins");
        while (each.hasNext()) {
            ConnectorPluginBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ConnectorPlugin> getConnectorPlugins() {
        return KafkaConnectStatusFluentImpl.build(this.connectorPlugins);
    }

    @Override
    public List<ConnectorPlugin> buildConnectorPlugins() {
        return KafkaConnectStatusFluentImpl.build(this.connectorPlugins);
    }

    @Override
    public ConnectorPlugin buildConnectorPlugin(int index) {
        return this.connectorPlugins.get(index).build();
    }

    @Override
    public ConnectorPlugin buildFirstConnectorPlugin() {
        return this.connectorPlugins.get(0).build();
    }

    @Override
    public ConnectorPlugin buildLastConnectorPlugin() {
        return this.connectorPlugins.get(this.connectorPlugins.size() - 1).build();
    }

    @Override
    public ConnectorPlugin buildMatchingConnectorPlugin(Predicate<ConnectorPluginBuilder> predicate) {
        for (ConnectorPluginBuilder item : this.connectorPlugins) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingConnectorPlugin(Predicate<ConnectorPluginBuilder> predicate) {
        for (ConnectorPluginBuilder item : this.connectorPlugins) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConnectorPlugins(List<ConnectorPlugin> connectorPlugins) {
        if (this.connectorPlugins != null) {
            this._visitables.get((Object)"connectorPlugins").removeAll(this.connectorPlugins);
        }
        if (connectorPlugins != null) {
            this.connectorPlugins = new ArrayList<ConnectorPluginBuilder>();
            for (ConnectorPlugin item : connectorPlugins) {
                this.addToConnectorPlugins(item);
            }
        } else {
            this.connectorPlugins = null;
        }
        return (A)this;
    }

    @Override
    public A withConnectorPlugins(ConnectorPlugin ... connectorPlugins) {
        if (this.connectorPlugins != null) {
            this.connectorPlugins.clear();
        }
        if (connectorPlugins != null) {
            for (ConnectorPlugin item : connectorPlugins) {
                this.addToConnectorPlugins(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConnectorPlugins() {
        return this.connectorPlugins != null && !this.connectorPlugins.isEmpty();
    }

    @Override
    public KafkaConnectStatusFluent.ConnectorPluginsNested<A> addNewConnectorPlugin() {
        return new ConnectorPluginsNestedImpl();
    }

    @Override
    public KafkaConnectStatusFluent.ConnectorPluginsNested<A> addNewConnectorPluginLike(ConnectorPlugin item) {
        return new ConnectorPluginsNestedImpl(-1, item);
    }

    @Override
    public KafkaConnectStatusFluent.ConnectorPluginsNested<A> setNewConnectorPluginLike(int index, ConnectorPlugin item) {
        return new ConnectorPluginsNestedImpl(index, item);
    }

    @Override
    public KafkaConnectStatusFluent.ConnectorPluginsNested<A> editConnectorPlugin(int index) {
        if (this.connectorPlugins.size() <= index) {
            throw new RuntimeException("Can't edit connectorPlugins. Index exceeds size.");
        }
        return this.setNewConnectorPluginLike(index, this.buildConnectorPlugin(index));
    }

    @Override
    public KafkaConnectStatusFluent.ConnectorPluginsNested<A> editFirstConnectorPlugin() {
        if (this.connectorPlugins.size() == 0) {
            throw new RuntimeException("Can't edit first connectorPlugins. The list is empty.");
        }
        return this.setNewConnectorPluginLike(0, this.buildConnectorPlugin(0));
    }

    @Override
    public KafkaConnectStatusFluent.ConnectorPluginsNested<A> editLastConnectorPlugin() {
        int index = this.connectorPlugins.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last connectorPlugins. The list is empty.");
        }
        return this.setNewConnectorPluginLike(index, this.buildConnectorPlugin(index));
    }

    @Override
    public KafkaConnectStatusFluent.ConnectorPluginsNested<A> editMatchingConnectorPlugin(Predicate<ConnectorPluginBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.connectorPlugins.size(); ++i) {
            if (!predicate.test(this.connectorPlugins.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching connectorPlugins. No match found.");
        }
        return this.setNewConnectorPluginLike(index, this.buildConnectorPlugin(index));
    }

    @Override
    public int getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(int replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return true;
    }

    @Override
    public String getLabelSelector() {
        return this.labelSelector;
    }

    @Override
    public A withLabelSelector(String labelSelector) {
        this.labelSelector = labelSelector;
        return (A)this;
    }

    @Override
    public Boolean hasLabelSelector() {
        return this.labelSelector != null;
    }

    @Override
    public A withNewLabelSelector(StringBuilder arg1) {
        return this.withLabelSelector(new String(arg1));
    }

    @Override
    public A withNewLabelSelector(int[] arg1, int arg2, int arg3) {
        return this.withLabelSelector(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewLabelSelector(char[] arg1) {
        return this.withLabelSelector(new String(arg1));
    }

    @Override
    public A withNewLabelSelector(StringBuffer arg1) {
        return this.withLabelSelector(new String(arg1));
    }

    @Override
    public A withNewLabelSelector(byte[] arg1, int arg2) {
        return this.withLabelSelector(new String(arg1, arg2));
    }

    @Override
    public A withNewLabelSelector(byte[] arg1) {
        return this.withLabelSelector(new String(arg1));
    }

    @Override
    public A withNewLabelSelector(char[] arg1, int arg2, int arg3) {
        return this.withLabelSelector(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewLabelSelector(byte[] arg1, int arg2, int arg3) {
        return this.withLabelSelector(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewLabelSelector(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.withLabelSelector(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewLabelSelector(String arg1) {
        return this.withLabelSelector(new String(arg1));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaConnectStatusFluentImpl that = (KafkaConnectStatusFluentImpl)o;
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        if (this.connectorPlugins != null ? !this.connectorPlugins.equals(that.connectorPlugins) : that.connectorPlugins != null) {
            return false;
        }
        if (this.replicas != that.replicas) {
            return false;
        }
        return !(this.labelSelector != null ? !this.labelSelector.equals(that.labelSelector) : that.labelSelector != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.url, this.connectorPlugins, this.replicas, this.labelSelector, super.hashCode());
    }

    public class ConnectorPluginsNestedImpl<N>
    extends ConnectorPluginFluentImpl<KafkaConnectStatusFluent.ConnectorPluginsNested<N>>
    implements KafkaConnectStatusFluent.ConnectorPluginsNested<N>,
    Nested<N> {
        private final ConnectorPluginBuilder builder;
        private final int index;

        ConnectorPluginsNestedImpl(int index, ConnectorPlugin item) {
            this.index = index;
            this.builder = new ConnectorPluginBuilder(this, item);
        }

        ConnectorPluginsNestedImpl() {
            this.index = -1;
            this.builder = new ConnectorPluginBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaConnectStatusFluentImpl.this.setToConnectorPlugins(this.index, this.builder.build());
        }

        @Override
        public N endConnectorPlugin() {
            return this.and();
        }
    }
}

