/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.listener.RouteListenerBootstrapOverride;
import io.strimzi.api.kafka.model.listener.RouteListenerBootstrapOverrideBuilder;
import io.strimzi.api.kafka.model.listener.RouteListenerBootstrapOverrideFluentImpl;
import io.strimzi.api.kafka.model.listener.RouteListenerBrokerOverride;
import io.strimzi.api.kafka.model.listener.RouteListenerBrokerOverrideBuilder;
import io.strimzi.api.kafka.model.listener.RouteListenerBrokerOverrideFluentImpl;
import io.strimzi.api.kafka.model.listener.RouteListenerOverride;
import io.strimzi.api.kafka.model.listener.RouteListenerOverrideFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class RouteListenerOverrideFluentImpl<A extends RouteListenerOverrideFluent<A>>
extends BaseFluent<A>
implements RouteListenerOverrideFluent<A> {
    private RouteListenerBootstrapOverrideBuilder bootstrap;
    private List<RouteListenerBrokerOverrideBuilder> brokers;

    public RouteListenerOverrideFluentImpl() {
    }

    public RouteListenerOverrideFluentImpl(RouteListenerOverride instance) {
        this.withBootstrap(instance.getBootstrap());
        this.withBrokers(instance.getBrokers());
    }

    @Override
    @Deprecated
    public RouteListenerBootstrapOverride getBootstrap() {
        return this.bootstrap != null ? this.bootstrap.build() : null;
    }

    @Override
    public RouteListenerBootstrapOverride buildBootstrap() {
        return this.bootstrap != null ? this.bootstrap.build() : null;
    }

    @Override
    public A withBootstrap(RouteListenerBootstrapOverride bootstrap) {
        this._visitables.get((Object)"bootstrap").remove(this.bootstrap);
        if (bootstrap != null) {
            this.bootstrap = new RouteListenerBootstrapOverrideBuilder(bootstrap);
            this._visitables.get((Object)"bootstrap").add(this.bootstrap);
        }
        return (A)this;
    }

    @Override
    public Boolean hasBootstrap() {
        return this.bootstrap != null;
    }

    @Override
    public RouteListenerOverrideFluent.BootstrapNested<A> withNewBootstrap() {
        return new BootstrapNestedImpl();
    }

    @Override
    public RouteListenerOverrideFluent.BootstrapNested<A> withNewBootstrapLike(RouteListenerBootstrapOverride item) {
        return new BootstrapNestedImpl(item);
    }

    @Override
    public RouteListenerOverrideFluent.BootstrapNested<A> editBootstrap() {
        return this.withNewBootstrapLike(this.getBootstrap());
    }

    @Override
    public RouteListenerOverrideFluent.BootstrapNested<A> editOrNewBootstrap() {
        return this.withNewBootstrapLike(this.getBootstrap() != null ? this.getBootstrap() : new RouteListenerBootstrapOverrideBuilder().build());
    }

    @Override
    public RouteListenerOverrideFluent.BootstrapNested<A> editOrNewBootstrapLike(RouteListenerBootstrapOverride item) {
        return this.withNewBootstrapLike(this.getBootstrap() != null ? this.getBootstrap() : item);
    }

    @Override
    public A addToBrokers(int index, RouteListenerBrokerOverride item) {
        if (this.brokers == null) {
            this.brokers = new ArrayList<RouteListenerBrokerOverrideBuilder>();
        }
        RouteListenerBrokerOverrideBuilder builder = new RouteListenerBrokerOverrideBuilder(item);
        this._visitables.get((Object)"brokers").add(index >= 0 ? index : this._visitables.get((Object)"brokers").size(), builder);
        this.brokers.add(index >= 0 ? index : this.brokers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToBrokers(int index, RouteListenerBrokerOverride item) {
        if (this.brokers == null) {
            this.brokers = new ArrayList<RouteListenerBrokerOverrideBuilder>();
        }
        RouteListenerBrokerOverrideBuilder builder = new RouteListenerBrokerOverrideBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"brokers").size()) {
            this._visitables.get((Object)"brokers").add(builder);
        } else {
            this._visitables.get((Object)"brokers").set(index, builder);
        }
        if (index < 0 || index >= this.brokers.size()) {
            this.brokers.add(builder);
        } else {
            this.brokers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToBrokers(RouteListenerBrokerOverride ... items) {
        if (this.brokers == null) {
            this.brokers = new ArrayList<RouteListenerBrokerOverrideBuilder>();
        }
        for (RouteListenerBrokerOverride item : items) {
            RouteListenerBrokerOverrideBuilder builder = new RouteListenerBrokerOverrideBuilder(item);
            this._visitables.get((Object)"brokers").add(builder);
            this.brokers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToBrokers(Collection<RouteListenerBrokerOverride> items) {
        if (this.brokers == null) {
            this.brokers = new ArrayList<RouteListenerBrokerOverrideBuilder>();
        }
        for (RouteListenerBrokerOverride item : items) {
            RouteListenerBrokerOverrideBuilder builder = new RouteListenerBrokerOverrideBuilder(item);
            this._visitables.get((Object)"brokers").add(builder);
            this.brokers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromBrokers(RouteListenerBrokerOverride ... items) {
        for (RouteListenerBrokerOverride item : items) {
            RouteListenerBrokerOverrideBuilder builder = new RouteListenerBrokerOverrideBuilder(item);
            this._visitables.get((Object)"brokers").remove(builder);
            if (this.brokers == null) continue;
            this.brokers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromBrokers(Collection<RouteListenerBrokerOverride> items) {
        for (RouteListenerBrokerOverride item : items) {
            RouteListenerBrokerOverrideBuilder builder = new RouteListenerBrokerOverrideBuilder(item);
            this._visitables.get((Object)"brokers").remove(builder);
            if (this.brokers == null) continue;
            this.brokers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromBrokers(Predicate<RouteListenerBrokerOverrideBuilder> predicate) {
        if (this.brokers == null) {
            return (A)this;
        }
        Iterator<RouteListenerBrokerOverrideBuilder> each = this.brokers.iterator();
        List visitables = this._visitables.get((Object)"brokers");
        while (each.hasNext()) {
            RouteListenerBrokerOverrideBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<RouteListenerBrokerOverride> getBrokers() {
        return RouteListenerOverrideFluentImpl.build(this.brokers);
    }

    @Override
    public List<RouteListenerBrokerOverride> buildBrokers() {
        return RouteListenerOverrideFluentImpl.build(this.brokers);
    }

    @Override
    public RouteListenerBrokerOverride buildBroker(int index) {
        return this.brokers.get(index).build();
    }

    @Override
    public RouteListenerBrokerOverride buildFirstBroker() {
        return this.brokers.get(0).build();
    }

    @Override
    public RouteListenerBrokerOverride buildLastBroker() {
        return this.brokers.get(this.brokers.size() - 1).build();
    }

    @Override
    public RouteListenerBrokerOverride buildMatchingBroker(Predicate<RouteListenerBrokerOverrideBuilder> predicate) {
        for (RouteListenerBrokerOverrideBuilder item : this.brokers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingBroker(Predicate<RouteListenerBrokerOverrideBuilder> predicate) {
        for (RouteListenerBrokerOverrideBuilder item : this.brokers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withBrokers(List<RouteListenerBrokerOverride> brokers) {
        if (this.brokers != null) {
            this._visitables.get((Object)"brokers").removeAll(this.brokers);
        }
        if (brokers != null) {
            this.brokers = new ArrayList<RouteListenerBrokerOverrideBuilder>();
            for (RouteListenerBrokerOverride item : brokers) {
                this.addToBrokers(item);
            }
        } else {
            this.brokers = null;
        }
        return (A)this;
    }

    @Override
    public A withBrokers(RouteListenerBrokerOverride ... brokers) {
        if (this.brokers != null) {
            this.brokers.clear();
        }
        if (brokers != null) {
            for (RouteListenerBrokerOverride item : brokers) {
                this.addToBrokers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasBrokers() {
        return this.brokers != null && !this.brokers.isEmpty();
    }

    @Override
    public RouteListenerOverrideFluent.BrokersNested<A> addNewBroker() {
        return new BrokersNestedImpl();
    }

    @Override
    public RouteListenerOverrideFluent.BrokersNested<A> addNewBrokerLike(RouteListenerBrokerOverride item) {
        return new BrokersNestedImpl(-1, item);
    }

    @Override
    public RouteListenerOverrideFluent.BrokersNested<A> setNewBrokerLike(int index, RouteListenerBrokerOverride item) {
        return new BrokersNestedImpl(index, item);
    }

    @Override
    public RouteListenerOverrideFluent.BrokersNested<A> editBroker(int index) {
        if (this.brokers.size() <= index) {
            throw new RuntimeException("Can't edit brokers. Index exceeds size.");
        }
        return this.setNewBrokerLike(index, this.buildBroker(index));
    }

    @Override
    public RouteListenerOverrideFluent.BrokersNested<A> editFirstBroker() {
        if (this.brokers.size() == 0) {
            throw new RuntimeException("Can't edit first brokers. The list is empty.");
        }
        return this.setNewBrokerLike(0, this.buildBroker(0));
    }

    @Override
    public RouteListenerOverrideFluent.BrokersNested<A> editLastBroker() {
        int index = this.brokers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last brokers. The list is empty.");
        }
        return this.setNewBrokerLike(index, this.buildBroker(index));
    }

    @Override
    public RouteListenerOverrideFluent.BrokersNested<A> editMatchingBroker(Predicate<RouteListenerBrokerOverrideBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.brokers.size(); ++i) {
            if (!predicate.test(this.brokers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching brokers. No match found.");
        }
        return this.setNewBrokerLike(index, this.buildBroker(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteListenerOverrideFluentImpl that = (RouteListenerOverrideFluentImpl)o;
        if (this.bootstrap != null ? !this.bootstrap.equals(that.bootstrap) : that.bootstrap != null) {
            return false;
        }
        return !(this.brokers != null ? !this.brokers.equals(that.brokers) : that.brokers != null);
    }

    public int hashCode() {
        return Objects.hash(this.bootstrap, this.brokers, super.hashCode());
    }

    public class BrokersNestedImpl<N>
    extends RouteListenerBrokerOverrideFluentImpl<RouteListenerOverrideFluent.BrokersNested<N>>
    implements RouteListenerOverrideFluent.BrokersNested<N>,
    Nested<N> {
        private final RouteListenerBrokerOverrideBuilder builder;
        private final int index;

        BrokersNestedImpl(int index, RouteListenerBrokerOverride item) {
            this.index = index;
            this.builder = new RouteListenerBrokerOverrideBuilder(this, item);
        }

        BrokersNestedImpl() {
            this.index = -1;
            this.builder = new RouteListenerBrokerOverrideBuilder(this);
        }

        @Override
        public N and() {
            return (N)RouteListenerOverrideFluentImpl.this.setToBrokers(this.index, this.builder.build());
        }

        @Override
        public N endBroker() {
            return this.and();
        }
    }

    public class BootstrapNestedImpl<N>
    extends RouteListenerBootstrapOverrideFluentImpl<RouteListenerOverrideFluent.BootstrapNested<N>>
    implements RouteListenerOverrideFluent.BootstrapNested<N>,
    Nested<N> {
        private final RouteListenerBootstrapOverrideBuilder builder;

        BootstrapNestedImpl(RouteListenerBootstrapOverride item) {
            this.builder = new RouteListenerBootstrapOverrideBuilder(this, item);
        }

        BootstrapNestedImpl() {
            this.builder = new RouteListenerBootstrapOverrideBuilder(this);
        }

        @Override
        public N and() {
            return (N)RouteListenerOverrideFluentImpl.this.withBootstrap(this.builder.build());
        }

        @Override
        public N endBootstrap() {
            return this.and();
        }
    }
}

