/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.listener.NodePortListenerConfiguration;
import io.strimzi.api.kafka.model.listener.NodePortListenerConfigurationFluent;
import io.strimzi.api.kafka.model.listener.NodePortListenerConfigurationFluentImpl;
import java.util.Objects;

public class NodePortListenerConfigurationBuilder
extends NodePortListenerConfigurationFluentImpl<NodePortListenerConfigurationBuilder>
implements VisitableBuilder<NodePortListenerConfiguration, NodePortListenerConfigurationBuilder> {
    NodePortListenerConfigurationFluent<?> fluent;
    Boolean validationEnabled;

    public NodePortListenerConfigurationBuilder() {
        this(true);
    }

    public NodePortListenerConfigurationBuilder(Boolean validationEnabled) {
        this(new NodePortListenerConfiguration(), validationEnabled);
    }

    public NodePortListenerConfigurationBuilder(NodePortListenerConfigurationFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NodePortListenerConfigurationBuilder(NodePortListenerConfigurationFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NodePortListenerConfiguration(), validationEnabled);
    }

    public NodePortListenerConfigurationBuilder(NodePortListenerConfigurationFluent<?> fluent, NodePortListenerConfiguration instance) {
        this(fluent, instance, true);
    }

    public NodePortListenerConfigurationBuilder(NodePortListenerConfigurationFluent<?> fluent, NodePortListenerConfiguration instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withPreferredAddressType(instance.getPreferredAddressType());
        fluent.withBrokerCertChainAndKey(instance.getBrokerCertChainAndKey());
        this.validationEnabled = validationEnabled;
    }

    public NodePortListenerConfigurationBuilder(NodePortListenerConfiguration instance) {
        this(instance, (Boolean)true);
    }

    public NodePortListenerConfigurationBuilder(NodePortListenerConfiguration instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withPreferredAddressType(instance.getPreferredAddressType());
        this.withBrokerCertChainAndKey(instance.getBrokerCertChainAndKey());
        this.validationEnabled = validationEnabled;
    }

    public NodePortListenerConfiguration build() {
        NodePortListenerConfiguration buildable = new NodePortListenerConfiguration();
        buildable.setBrokerCertChainAndKey(this.fluent.getBrokerCertChainAndKey());
        buildable.setPreferredAddressType(this.fluent.getPreferredAddressType());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodePortListenerConfigurationBuilder that = (NodePortListenerConfigurationBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

