/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.listener.KafkaListenerTls;
import io.strimzi.api.kafka.model.listener.KafkaListenerTlsFluent;
import io.strimzi.api.kafka.model.listener.KafkaListenerTlsFluentImpl;
import java.util.Objects;

public class KafkaListenerTlsBuilder
extends KafkaListenerTlsFluentImpl<KafkaListenerTlsBuilder>
implements VisitableBuilder<KafkaListenerTls, KafkaListenerTlsBuilder> {
    KafkaListenerTlsFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaListenerTlsBuilder() {
        this(true);
    }

    public KafkaListenerTlsBuilder(Boolean validationEnabled) {
        this(new KafkaListenerTls(), validationEnabled);
    }

    public KafkaListenerTlsBuilder(KafkaListenerTlsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KafkaListenerTlsBuilder(KafkaListenerTlsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KafkaListenerTls(), validationEnabled);
    }

    public KafkaListenerTlsBuilder(KafkaListenerTlsFluent<?> fluent, KafkaListenerTls instance) {
        this(fluent, instance, true);
    }

    public KafkaListenerTlsBuilder(KafkaListenerTlsFluent<?> fluent, KafkaListenerTls instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAuth(instance.getAuth());
        fluent.withNetworkPolicyPeers(instance.getNetworkPolicyPeers());
        fluent.withConfiguration(instance.getConfiguration());
        this.validationEnabled = validationEnabled;
    }

    public KafkaListenerTlsBuilder(KafkaListenerTls instance) {
        this(instance, (Boolean)true);
    }

    public KafkaListenerTlsBuilder(KafkaListenerTls instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAuth(instance.getAuth());
        this.withNetworkPolicyPeers(instance.getNetworkPolicyPeers());
        this.withConfiguration(instance.getConfiguration());
        this.validationEnabled = validationEnabled;
    }

    public KafkaListenerTls build() {
        KafkaListenerTls buildable = new KafkaListenerTls();
        buildable.setAuth(this.fluent.getAuth());
        buildable.setNetworkPolicyPeers(this.fluent.getNetworkPolicyPeers());
        buildable.setConfiguration(this.fluent.getConfiguration());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaListenerTlsBuilder that = (KafkaListenerTlsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

