/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthentication;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuth;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthBuilder;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluentImpl;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512Builder;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512FluentImpl;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTls;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTlsBuilder;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTlsFluentImpl;
import io.strimzi.api.kafka.model.listener.KafkaListenerExternalNodePort;
import io.strimzi.api.kafka.model.listener.KafkaListenerExternalNodePortFluent;
import io.strimzi.api.kafka.model.listener.NodePortListenerConfiguration;
import io.strimzi.api.kafka.model.listener.NodePortListenerConfigurationBuilder;
import io.strimzi.api.kafka.model.listener.NodePortListenerConfigurationFluentImpl;
import io.strimzi.api.kafka.model.listener.NodePortListenerOverride;
import io.strimzi.api.kafka.model.listener.NodePortListenerOverrideBuilder;
import io.strimzi.api.kafka.model.listener.NodePortListenerOverrideFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class KafkaListenerExternalNodePortFluentImpl<A extends KafkaListenerExternalNodePortFluent<A>>
extends BaseFluent<A>
implements KafkaListenerExternalNodePortFluent<A> {
    private VisitableBuilder<? extends KafkaListenerAuthentication, ?> auth;
    private boolean tls;
    private List<NetworkPolicyPeer> networkPolicyPeers;
    private NodePortListenerOverrideBuilder overrides;
    private NodePortListenerConfigurationBuilder configuration;

    public KafkaListenerExternalNodePortFluentImpl() {
    }

    public KafkaListenerExternalNodePortFluentImpl(KafkaListenerExternalNodePort instance) {
        this.withAuth(instance.getAuth());
        this.withTls(instance.isTls());
        this.withNetworkPolicyPeers(instance.getNetworkPolicyPeers());
        this.withOverrides(instance.getOverrides());
        this.withConfiguration(instance.getConfiguration());
    }

    @Override
    @Deprecated
    public KafkaListenerAuthentication getAuth() {
        return this.auth != null ? (KafkaListenerAuthentication)this.auth.build() : null;
    }

    @Override
    public KafkaListenerAuthentication buildAuth() {
        return this.auth != null ? (KafkaListenerAuthentication)this.auth.build() : null;
    }

    @Override
    public A withAuth(KafkaListenerAuthentication auth) {
        this._visitables.get((Object)"auth").remove(this.auth);
        if (auth instanceof KafkaListenerAuthenticationOAuth) {
            this.auth = new KafkaListenerAuthenticationOAuthBuilder((KafkaListenerAuthenticationOAuth)auth);
            this._visitables.get((Object)"auth").add(this.auth);
        }
        if (auth instanceof KafkaListenerAuthenticationTls) {
            this.auth = new KafkaListenerAuthenticationTlsBuilder((KafkaListenerAuthenticationTls)auth);
            this._visitables.get((Object)"auth").add(this.auth);
        }
        if (auth instanceof KafkaListenerAuthenticationScramSha512) {
            this.auth = new KafkaListenerAuthenticationScramSha512Builder((KafkaListenerAuthenticationScramSha512)auth);
            this._visitables.get((Object)"auth").add(this.auth);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAuth() {
        return this.auth != null;
    }

    @Override
    public A withKafkaListenerAuthenticationOAuth(KafkaListenerAuthenticationOAuth kafkaListenerAuthenticationOAuth) {
        this._visitables.get((Object)"auth").remove(this.auth);
        if (kafkaListenerAuthenticationOAuth != null) {
            this.auth = new KafkaListenerAuthenticationOAuthBuilder(kafkaListenerAuthenticationOAuth);
            this._visitables.get((Object)"auth").add(this.auth);
        }
        return (A)this;
    }

    @Override
    public KafkaListenerExternalNodePortFluent.KafkaListenerAuthenticationOAuthNested<A> withNewKafkaListenerAuthenticationOAuth() {
        return new KafkaListenerAuthenticationOAuthNestedImpl();
    }

    @Override
    public KafkaListenerExternalNodePortFluent.KafkaListenerAuthenticationOAuthNested<A> withNewKafkaListenerAuthenticationOAuthLike(KafkaListenerAuthenticationOAuth item) {
        return new KafkaListenerAuthenticationOAuthNestedImpl(item);
    }

    @Override
    public A withKafkaListenerAuthenticationTlsAuth(KafkaListenerAuthenticationTls kafkaListenerAuthenticationTlsAuth) {
        this._visitables.get((Object)"auth").remove(this.auth);
        if (kafkaListenerAuthenticationTlsAuth != null) {
            this.auth = new KafkaListenerAuthenticationTlsBuilder(kafkaListenerAuthenticationTlsAuth);
            this._visitables.get((Object)"auth").add(this.auth);
        }
        return (A)this;
    }

    @Override
    public KafkaListenerExternalNodePortFluent.KafkaListenerAuthenticationTlsAuthNested<A> withNewKafkaListenerAuthenticationTlsAuth() {
        return new KafkaListenerAuthenticationTlsAuthNestedImpl();
    }

    @Override
    public KafkaListenerExternalNodePortFluent.KafkaListenerAuthenticationTlsAuthNested<A> withNewKafkaListenerAuthenticationTlsAuthLike(KafkaListenerAuthenticationTls item) {
        return new KafkaListenerAuthenticationTlsAuthNestedImpl(item);
    }

    @Override
    public A withKafkaListenerAuthenticationScramSha512Auth(KafkaListenerAuthenticationScramSha512 kafkaListenerAuthenticationScramSha512Auth) {
        this._visitables.get((Object)"auth").remove(this.auth);
        if (kafkaListenerAuthenticationScramSha512Auth != null) {
            this.auth = new KafkaListenerAuthenticationScramSha512Builder(kafkaListenerAuthenticationScramSha512Auth);
            this._visitables.get((Object)"auth").add(this.auth);
        }
        return (A)this;
    }

    @Override
    public KafkaListenerExternalNodePortFluent.KafkaListenerAuthenticationScramSha512AuthNested<A> withNewKafkaListenerAuthenticationScramSha512Auth() {
        return new KafkaListenerAuthenticationScramSha512AuthNestedImpl();
    }

    @Override
    public KafkaListenerExternalNodePortFluent.KafkaListenerAuthenticationScramSha512AuthNested<A> withNewKafkaListenerAuthenticationScramSha512AuthLike(KafkaListenerAuthenticationScramSha512 item) {
        return new KafkaListenerAuthenticationScramSha512AuthNestedImpl(item);
    }

    @Override
    public boolean isTls() {
        return this.tls;
    }

    @Override
    public A withTls(boolean tls) {
        this.tls = tls;
        return (A)this;
    }

    @Override
    public Boolean hasTls() {
        return true;
    }

    @Override
    public A addToNetworkPolicyPeers(int index, NetworkPolicyPeer item) {
        if (this.networkPolicyPeers == null) {
            this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();
        }
        this.networkPolicyPeers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNetworkPolicyPeers(int index, NetworkPolicyPeer item) {
        if (this.networkPolicyPeers == null) {
            this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();
        }
        this.networkPolicyPeers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNetworkPolicyPeers(NetworkPolicyPeer ... items) {
        if (this.networkPolicyPeers == null) {
            this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();
        }
        for (NetworkPolicyPeer item : items) {
            this.networkPolicyPeers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNetworkPolicyPeers(Collection<NetworkPolicyPeer> items) {
        if (this.networkPolicyPeers == null) {
            this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();
        }
        for (NetworkPolicyPeer item : items) {
            this.networkPolicyPeers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNetworkPolicyPeers(NetworkPolicyPeer ... items) {
        for (NetworkPolicyPeer item : items) {
            if (this.networkPolicyPeers == null) continue;
            this.networkPolicyPeers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNetworkPolicyPeers(Collection<NetworkPolicyPeer> items) {
        for (NetworkPolicyPeer item : items) {
            if (this.networkPolicyPeers == null) continue;
            this.networkPolicyPeers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<NetworkPolicyPeer> getNetworkPolicyPeers() {
        return this.networkPolicyPeers;
    }

    @Override
    public NetworkPolicyPeer getNetworkPolicyPeer(int index) {
        return this.networkPolicyPeers.get(index);
    }

    @Override
    public NetworkPolicyPeer getFirstNetworkPolicyPeer() {
        return this.networkPolicyPeers.get(0);
    }

    @Override
    public NetworkPolicyPeer getLastNetworkPolicyPeer() {
        return this.networkPolicyPeers.get(this.networkPolicyPeers.size() - 1);
    }

    @Override
    public NetworkPolicyPeer getMatchingNetworkPolicyPeer(Predicate<NetworkPolicyPeer> predicate) {
        for (NetworkPolicyPeer item : this.networkPolicyPeers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNetworkPolicyPeer(Predicate<NetworkPolicyPeer> predicate) {
        for (NetworkPolicyPeer item : this.networkPolicyPeers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNetworkPolicyPeers(List<NetworkPolicyPeer> networkPolicyPeers) {
        if (this.networkPolicyPeers != null) {
            this._visitables.get((Object)"networkPolicyPeers").removeAll(this.networkPolicyPeers);
        }
        if (networkPolicyPeers != null) {
            this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();
            for (NetworkPolicyPeer item : networkPolicyPeers) {
                this.addToNetworkPolicyPeers(item);
            }
        } else {
            this.networkPolicyPeers = null;
        }
        return (A)this;
    }

    @Override
    public A withNetworkPolicyPeers(NetworkPolicyPeer ... networkPolicyPeers) {
        if (this.networkPolicyPeers != null) {
            this.networkPolicyPeers.clear();
        }
        if (networkPolicyPeers != null) {
            for (NetworkPolicyPeer item : networkPolicyPeers) {
                this.addToNetworkPolicyPeers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNetworkPolicyPeers() {
        return this.networkPolicyPeers != null && !this.networkPolicyPeers.isEmpty();
    }

    @Override
    @Deprecated
    public NodePortListenerOverride getOverrides() {
        return this.overrides != null ? this.overrides.build() : null;
    }

    @Override
    public NodePortListenerOverride buildOverrides() {
        return this.overrides != null ? this.overrides.build() : null;
    }

    @Override
    public A withOverrides(NodePortListenerOverride overrides) {
        this._visitables.get((Object)"overrides").remove(this.overrides);
        if (overrides != null) {
            this.overrides = new NodePortListenerOverrideBuilder(overrides);
            this._visitables.get((Object)"overrides").add(this.overrides);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOverrides() {
        return this.overrides != null;
    }

    @Override
    public KafkaListenerExternalNodePortFluent.OverridesNested<A> withNewOverrides() {
        return new OverridesNestedImpl();
    }

    @Override
    public KafkaListenerExternalNodePortFluent.OverridesNested<A> withNewOverridesLike(NodePortListenerOverride item) {
        return new OverridesNestedImpl(item);
    }

    @Override
    public KafkaListenerExternalNodePortFluent.OverridesNested<A> editOverrides() {
        return this.withNewOverridesLike(this.getOverrides());
    }

    @Override
    public KafkaListenerExternalNodePortFluent.OverridesNested<A> editOrNewOverrides() {
        return this.withNewOverridesLike(this.getOverrides() != null ? this.getOverrides() : new NodePortListenerOverrideBuilder().build());
    }

    @Override
    public KafkaListenerExternalNodePortFluent.OverridesNested<A> editOrNewOverridesLike(NodePortListenerOverride item) {
        return this.withNewOverridesLike(this.getOverrides() != null ? this.getOverrides() : item);
    }

    @Override
    @Deprecated
    public NodePortListenerConfiguration getConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    @Override
    public NodePortListenerConfiguration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    @Override
    public A withConfiguration(NodePortListenerConfiguration configuration) {
        this._visitables.get((Object)"configuration").remove(this.configuration);
        if (configuration != null) {
            this.configuration = new NodePortListenerConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfiguration() {
        return this.configuration != null;
    }

    @Override
    public KafkaListenerExternalNodePortFluent.ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNestedImpl();
    }

    @Override
    public KafkaListenerExternalNodePortFluent.ConfigurationNested<A> withNewConfigurationLike(NodePortListenerConfiguration item) {
        return new ConfigurationNestedImpl(item);
    }

    @Override
    public KafkaListenerExternalNodePortFluent.ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(this.getConfiguration());
    }

    @Override
    public KafkaListenerExternalNodePortFluent.ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(this.getConfiguration() != null ? this.getConfiguration() : new NodePortListenerConfigurationBuilder().build());
    }

    @Override
    public KafkaListenerExternalNodePortFluent.ConfigurationNested<A> editOrNewConfigurationLike(NodePortListenerConfiguration item) {
        return this.withNewConfigurationLike(this.getConfiguration() != null ? this.getConfiguration() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaListenerExternalNodePortFluentImpl that = (KafkaListenerExternalNodePortFluentImpl)o;
        if (this.auth != null ? !this.auth.equals(that.auth) : that.auth != null) {
            return false;
        }
        if (this.tls != that.tls) {
            return false;
        }
        if (this.networkPolicyPeers != null ? !this.networkPolicyPeers.equals(that.networkPolicyPeers) : that.networkPolicyPeers != null) {
            return false;
        }
        if (this.overrides != null ? !this.overrides.equals(that.overrides) : that.overrides != null) {
            return false;
        }
        return !(this.configuration != null ? !this.configuration.equals(that.configuration) : that.configuration != null);
    }

    public int hashCode() {
        return Objects.hash(this.auth, this.tls, this.networkPolicyPeers, this.overrides, this.configuration, super.hashCode());
    }

    public class ConfigurationNestedImpl<N>
    extends NodePortListenerConfigurationFluentImpl<KafkaListenerExternalNodePortFluent.ConfigurationNested<N>>
    implements KafkaListenerExternalNodePortFluent.ConfigurationNested<N>,
    Nested<N> {
        private final NodePortListenerConfigurationBuilder builder;

        ConfigurationNestedImpl(NodePortListenerConfiguration item) {
            this.builder = new NodePortListenerConfigurationBuilder(this, item);
        }

        ConfigurationNestedImpl() {
            this.builder = new NodePortListenerConfigurationBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaListenerExternalNodePortFluentImpl.this.withConfiguration(this.builder.build());
        }

        @Override
        public N endConfiguration() {
            return this.and();
        }
    }

    public class OverridesNestedImpl<N>
    extends NodePortListenerOverrideFluentImpl<KafkaListenerExternalNodePortFluent.OverridesNested<N>>
    implements KafkaListenerExternalNodePortFluent.OverridesNested<N>,
    Nested<N> {
        private final NodePortListenerOverrideBuilder builder;

        OverridesNestedImpl(NodePortListenerOverride item) {
            this.builder = new NodePortListenerOverrideBuilder(this, item);
        }

        OverridesNestedImpl() {
            this.builder = new NodePortListenerOverrideBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaListenerExternalNodePortFluentImpl.this.withOverrides(this.builder.build());
        }

        @Override
        public N endOverrides() {
            return this.and();
        }
    }

    public class KafkaListenerAuthenticationScramSha512AuthNestedImpl<N>
    extends KafkaListenerAuthenticationScramSha512FluentImpl<KafkaListenerExternalNodePortFluent.KafkaListenerAuthenticationScramSha512AuthNested<N>>
    implements KafkaListenerExternalNodePortFluent.KafkaListenerAuthenticationScramSha512AuthNested<N>,
    Nested<N> {
        private final KafkaListenerAuthenticationScramSha512Builder builder;

        KafkaListenerAuthenticationScramSha512AuthNestedImpl(KafkaListenerAuthenticationScramSha512 item) {
            this.builder = new KafkaListenerAuthenticationScramSha512Builder(this, item);
        }

        KafkaListenerAuthenticationScramSha512AuthNestedImpl() {
            this.builder = new KafkaListenerAuthenticationScramSha512Builder(this);
        }

        @Override
        public N and() {
            return (N)KafkaListenerExternalNodePortFluentImpl.this.withAuth(this.builder.build());
        }

        @Override
        public N endKafkaListenerAuthenticationScramSha512Auth() {
            return this.and();
        }
    }

    public class KafkaListenerAuthenticationTlsAuthNestedImpl<N>
    extends KafkaListenerAuthenticationTlsFluentImpl<KafkaListenerExternalNodePortFluent.KafkaListenerAuthenticationTlsAuthNested<N>>
    implements KafkaListenerExternalNodePortFluent.KafkaListenerAuthenticationTlsAuthNested<N>,
    Nested<N> {
        private final KafkaListenerAuthenticationTlsBuilder builder;

        KafkaListenerAuthenticationTlsAuthNestedImpl(KafkaListenerAuthenticationTls item) {
            this.builder = new KafkaListenerAuthenticationTlsBuilder(this, item);
        }

        KafkaListenerAuthenticationTlsAuthNestedImpl() {
            this.builder = new KafkaListenerAuthenticationTlsBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaListenerExternalNodePortFluentImpl.this.withAuth(this.builder.build());
        }

        @Override
        public N endKafkaListenerAuthenticationTlsAuth() {
            return this.and();
        }
    }

    public class KafkaListenerAuthenticationOAuthNestedImpl<N>
    extends KafkaListenerAuthenticationOAuthFluentImpl<KafkaListenerExternalNodePortFluent.KafkaListenerAuthenticationOAuthNested<N>>
    implements KafkaListenerExternalNodePortFluent.KafkaListenerAuthenticationOAuthNested<N>,
    Nested<N> {
        private final KafkaListenerAuthenticationOAuthBuilder builder;

        KafkaListenerAuthenticationOAuthNestedImpl(KafkaListenerAuthenticationOAuth item) {
            this.builder = new KafkaListenerAuthenticationOAuthBuilder(this, item);
        }

        KafkaListenerAuthenticationOAuthNestedImpl() {
            this.builder = new KafkaListenerAuthenticationOAuthBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaListenerExternalNodePortFluentImpl.this.withAuth(this.builder.build());
        }

        @Override
        public N endKafkaListenerAuthenticationOAuth() {
            return this.and();
        }
    }
}

