/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.listener;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthentication;
import io.strimzi.api.kafka.model.listener.KafkaListenerExternal;
import io.strimzi.api.kafka.model.listener.KafkaListenerExternalConfiguration;
import io.strimzi.api.kafka.model.listener.LoadBalancerListenerOverride;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.KubeLink;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "authentication", "overrides", "configuration"})
public class KafkaListenerExternalLoadBalancer
extends KafkaListenerExternal {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_LOADBALANCER = "loadbalancer";
    private KafkaListenerAuthentication auth;
    private boolean tls = true;
    private List<NetworkPolicyPeer> networkPolicyPeers;
    private LoadBalancerListenerOverride overrides;
    private KafkaListenerExternalConfiguration configuration;

    @Override
    @Description(value="Must be `loadbalancer`")
    public String getType() {
        return TYPE_LOADBALANCER;
    }

    @Override
    @Description(value="Authentication configuration for Kafka brokers")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="authentication")
    public KafkaListenerAuthentication getAuth() {
        return this.auth;
    }

    @Override
    public void setAuth(KafkaListenerAuthentication auth) {
        this.auth = auth;
    }

    @Description(value="Enables TLS encryption on the listener. By default set to `true` for enabled TLS encryption.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public boolean isTls() {
        return this.tls;
    }

    public void setTls(boolean tls) {
        this.tls = tls;
    }

    @Override
    @Description(value="List of peers which should be able to connect to this listener. Peers in this list are combined using a logical OR operation. If this field is empty or missing, all connections will be allowed for this listener. If this field is present and contains at least one item, the listener only allows the traffic which matches at least one item in this list.")
    @KubeLink(group="networking.k8s.io", version="v1", kind="networkpolicypeer")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<NetworkPolicyPeer> getNetworkPolicyPeers() {
        return this.networkPolicyPeers;
    }

    @Override
    public void setNetworkPolicyPeers(List<NetworkPolicyPeer> networkPolicyPeers) {
        this.networkPolicyPeers = networkPolicyPeers;
    }

    @Description(value="External listener configuration")
    public KafkaListenerExternalConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(KafkaListenerExternalConfiguration configuration) {
        this.configuration = configuration;
    }

    @Description(value="Overrides for external bootstrap and broker services and externally advertised addresses")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public LoadBalancerListenerOverride getOverrides() {
        return this.overrides;
    }

    public void setOverrides(LoadBalancerListenerOverride overrides) {
        this.overrides = overrides;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaListenerExternalLoadBalancer)) {
            return false;
        }
        KafkaListenerExternalLoadBalancer other = (KafkaListenerExternalLoadBalancer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        KafkaListenerAuthentication this$auth = this.getAuth();
        KafkaListenerAuthentication other$auth = other.getAuth();
        if (this$auth == null ? other$auth != null : !((Object)this$auth).equals(other$auth)) {
            return false;
        }
        if (this.isTls() != other.isTls()) {
            return false;
        }
        List<NetworkPolicyPeer> this$networkPolicyPeers = this.getNetworkPolicyPeers();
        List<NetworkPolicyPeer> other$networkPolicyPeers = other.getNetworkPolicyPeers();
        if (this$networkPolicyPeers == null ? other$networkPolicyPeers != null : !((Object)this$networkPolicyPeers).equals(other$networkPolicyPeers)) {
            return false;
        }
        LoadBalancerListenerOverride this$overrides = this.getOverrides();
        LoadBalancerListenerOverride other$overrides = other.getOverrides();
        if (this$overrides == null ? other$overrides != null : !((Object)this$overrides).equals(other$overrides)) {
            return false;
        }
        KafkaListenerExternalConfiguration this$configuration = this.getConfiguration();
        KafkaListenerExternalConfiguration other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaListenerExternalLoadBalancer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KafkaListenerAuthentication $auth = this.getAuth();
        result = result * 59 + ($auth == null ? 43 : ((Object)$auth).hashCode());
        result = result * 59 + (this.isTls() ? 79 : 97);
        List<NetworkPolicyPeer> $networkPolicyPeers = this.getNetworkPolicyPeers();
        result = result * 59 + ($networkPolicyPeers == null ? 43 : ((Object)$networkPolicyPeers).hashCode());
        LoadBalancerListenerOverride $overrides = this.getOverrides();
        result = result * 59 + ($overrides == null ? 43 : ((Object)$overrides).hashCode());
        KafkaListenerExternalConfiguration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        return result;
    }
}

