/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.connect.build.ZipArtifact;
import io.strimzi.api.kafka.model.connect.build.ZipArtifactFluent;
import io.strimzi.api.kafka.model.connect.build.ZipArtifactFluentImpl;
import java.util.Objects;

public class ZipArtifactBuilder
extends ZipArtifactFluentImpl<ZipArtifactBuilder>
implements VisitableBuilder<ZipArtifact, ZipArtifactBuilder> {
    ZipArtifactFluent<?> fluent;
    Boolean validationEnabled;

    public ZipArtifactBuilder() {
        this(true);
    }

    public ZipArtifactBuilder(Boolean validationEnabled) {
        this(new ZipArtifact(), validationEnabled);
    }

    public ZipArtifactBuilder(ZipArtifactFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ZipArtifactBuilder(ZipArtifactFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ZipArtifact(), validationEnabled);
    }

    public ZipArtifactBuilder(ZipArtifactFluent<?> fluent, ZipArtifact instance) {
        this(fluent, instance, true);
    }

    public ZipArtifactBuilder(ZipArtifactFluent<?> fluent, ZipArtifact instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withUrl(instance.getUrl());
        fluent.withSha512sum(instance.getSha512sum());
        this.validationEnabled = validationEnabled;
    }

    public ZipArtifactBuilder(ZipArtifact instance) {
        this(instance, (Boolean)true);
    }

    public ZipArtifactBuilder(ZipArtifact instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withUrl(instance.getUrl());
        this.withSha512sum(instance.getSha512sum());
        this.validationEnabled = validationEnabled;
    }

    public ZipArtifact build() {
        ZipArtifact buildable = new ZipArtifact();
        buildable.setUrl(this.fluent.getUrl());
        buildable.setSha512sum(this.fluent.getSha512sum());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ZipArtifactBuilder that = (ZipArtifactBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

