/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.authentication;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.strimzi.api.kafka.model.CertSecretSource;
import io.strimzi.api.kafka.model.GenericSecretSource;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import java.util.List;

@DescriptionFile
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class KafkaClientAuthenticationOAuth
extends KafkaClientAuthentication {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_OAUTH = "oauth";
    private String clientId;
    private String scope;
    private String tokenEndpointUri;
    private GenericSecretSource clientSecret;
    private GenericSecretSource accessToken;
    private GenericSecretSource refreshToken;
    private List<CertSecretSource> tlsTrustedCertificates;
    private boolean disableTlsHostnameVerification = false;
    private int maxTokenExpirySeconds = 0;
    private boolean accessTokenIsJwt = true;

    @Override
    @Description(value="Must be `oauth`")
    public String getType() {
        return TYPE_OAUTH;
    }

    @Description(value="OAuth Client ID which the Kafka client can use to authenticate against the OAuth server and use the token endpoint URI.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Description(value="OAuth scope to use when authenticating against the authorization server. Some authorization servers require this to be set. The possible values depend on how authorization server is configured. By default `scope` is not specified when doing the token endpoint request.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @Description(value="Authorization server token endpoint URI.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTokenEndpointUri() {
        return this.tokenEndpointUri;
    }

    public void setTokenEndpointUri(String tokenEndpointUri) {
        this.tokenEndpointUri = tokenEndpointUri;
    }

    @Description(value="Link to Kubernetes Secret containing the OAuth client secret which the Kafka client can use to authenticate against the OAuth server and use the token endpoint URI.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public GenericSecretSource getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(GenericSecretSource clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Description(value="Link to Kubernetes Secret containing the access token which was obtained from the authorization server.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public GenericSecretSource getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(GenericSecretSource accessToken) {
        this.accessToken = accessToken;
    }

    @Description(value="Link to Kubernetes Secret containing the refresh token which can be used to obtain access token from the authorization server.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public GenericSecretSource getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(GenericSecretSource refreshToken) {
        this.refreshToken = refreshToken;
    }

    @Description(value="Trusted certificates for TLS connection to the OAuth server.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CertSecretSource> getTlsTrustedCertificates() {
        return this.tlsTrustedCertificates;
    }

    public void setTlsTrustedCertificates(List<CertSecretSource> tlsTrustedCertificates) {
        this.tlsTrustedCertificates = tlsTrustedCertificates;
    }

    @Description(value="Enable or disable TLS hostname verification. Default value is `false`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isDisableTlsHostnameVerification() {
        return this.disableTlsHostnameVerification;
    }

    public void setDisableTlsHostnameVerification(boolean disableTlsHostnameVerification) {
        this.disableTlsHostnameVerification = disableTlsHostnameVerification;
    }

    @Description(value="Set or limit time-to-live of the access tokens to the specified number of seconds. This should be set if the authorization server returns opaque tokens.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public int getMaxTokenExpirySeconds() {
        return this.maxTokenExpirySeconds;
    }

    public void setMaxTokenExpirySeconds(int maxTokenExpirySeconds) {
        this.maxTokenExpirySeconds = maxTokenExpirySeconds;
    }

    @Description(value="Configure whether access token should be treated as JWT. This should be set to `false` if the authorization server returns opaque tokens. Defaults to `true`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isAccessTokenIsJwt() {
        return this.accessTokenIsJwt;
    }

    public void setAccessTokenIsJwt(boolean accessTokenIsJwt) {
        this.accessTokenIsJwt = accessTokenIsJwt;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaClientAuthenticationOAuth)) {
            return false;
        }
        KafkaClientAuthenticationOAuth other = (KafkaClientAuthenticationOAuth)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$tokenEndpointUri = this.getTokenEndpointUri();
        String other$tokenEndpointUri = other.getTokenEndpointUri();
        if (this$tokenEndpointUri == null ? other$tokenEndpointUri != null : !this$tokenEndpointUri.equals(other$tokenEndpointUri)) {
            return false;
        }
        GenericSecretSource this$clientSecret = this.getClientSecret();
        GenericSecretSource other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !((Object)this$clientSecret).equals(other$clientSecret)) {
            return false;
        }
        GenericSecretSource this$accessToken = this.getAccessToken();
        GenericSecretSource other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !((Object)this$accessToken).equals(other$accessToken)) {
            return false;
        }
        GenericSecretSource this$refreshToken = this.getRefreshToken();
        GenericSecretSource other$refreshToken = other.getRefreshToken();
        if (this$refreshToken == null ? other$refreshToken != null : !((Object)this$refreshToken).equals(other$refreshToken)) {
            return false;
        }
        List<CertSecretSource> this$tlsTrustedCertificates = this.getTlsTrustedCertificates();
        List<CertSecretSource> other$tlsTrustedCertificates = other.getTlsTrustedCertificates();
        if (this$tlsTrustedCertificates == null ? other$tlsTrustedCertificates != null : !((Object)this$tlsTrustedCertificates).equals(other$tlsTrustedCertificates)) {
            return false;
        }
        if (this.isDisableTlsHostnameVerification() != other.isDisableTlsHostnameVerification()) {
            return false;
        }
        if (this.getMaxTokenExpirySeconds() != other.getMaxTokenExpirySeconds()) {
            return false;
        }
        return this.isAccessTokenIsJwt() == other.isAccessTokenIsJwt();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaClientAuthenticationOAuth;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $tokenEndpointUri = this.getTokenEndpointUri();
        result = result * 59 + ($tokenEndpointUri == null ? 43 : $tokenEndpointUri.hashCode());
        GenericSecretSource $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : ((Object)$clientSecret).hashCode());
        GenericSecretSource $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : ((Object)$accessToken).hashCode());
        GenericSecretSource $refreshToken = this.getRefreshToken();
        result = result * 59 + ($refreshToken == null ? 43 : ((Object)$refreshToken).hashCode());
        List<CertSecretSource> $tlsTrustedCertificates = this.getTlsTrustedCertificates();
        result = result * 59 + ($tlsTrustedCertificates == null ? 43 : ((Object)$tlsTrustedCertificates).hashCode());
        result = result * 59 + (this.isDisableTlsHostnameVerification() ? 79 : 97);
        result = result * 59 + this.getMaxTokenExpirySeconds();
        result = result * 59 + (this.isAccessTokenIsJwt() ? 79 : 97);
        return result;
    }
}

