/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.strimzi.api.kafka.model.UnknownPropertyPreserving;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import io.strimzi.crdgenerator.annotations.Minimum;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@DescriptionFile
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class KafkaUserQuotas
implements UnknownPropertyPreserving,
Serializable {
    private static final long serialVersionUID = 1L;
    private Integer producerByteRate;
    private Integer consumerByteRate;
    private Integer requestPercentage;
    private Map<String, Object> additionalProperties;

    @Description(value="A quota on the maximum bytes per-second that each client group can publish to a broker before the clients in the group are throttled. Defined on a per-broker basis.")
    @Minimum(value=0)
    public Integer getProducerByteRate() {
        return this.producerByteRate;
    }

    public void setProducerByteRate(Integer producerByteRate) {
        this.producerByteRate = producerByteRate;
    }

    @Description(value="A quota on the maximum bytes per-second that each client group can fetch from a broker before the clients in the group are throttled. Defined on a per-broker basis.")
    @Minimum(value=0)
    public Integer getConsumerByteRate() {
        return this.consumerByteRate;
    }

    public void setConsumerByteRate(Integer consumerByteRate) {
        this.consumerByteRate = consumerByteRate;
    }

    @Description(value="A quota on the maximum CPU utilization of each client group as a percentage of network and I/O threads.")
    @Minimum(value=0)
    public Integer getRequestPercentage() {
        return this.requestPercentage;
    }

    public void setRequestPercentage(Integer requestPercentage) {
        this.requestPercentage = requestPercentage;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Collections.emptyMap();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(1);
        }
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaUserQuotas)) {
            return false;
        }
        KafkaUserQuotas other = (KafkaUserQuotas)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$producerByteRate = this.getProducerByteRate();
        Integer other$producerByteRate = other.getProducerByteRate();
        if (this$producerByteRate == null ? other$producerByteRate != null : !((Object)this$producerByteRate).equals(other$producerByteRate)) {
            return false;
        }
        Integer this$consumerByteRate = this.getConsumerByteRate();
        Integer other$consumerByteRate = other.getConsumerByteRate();
        if (this$consumerByteRate == null ? other$consumerByteRate != null : !((Object)this$consumerByteRate).equals(other$consumerByteRate)) {
            return false;
        }
        Integer this$requestPercentage = this.getRequestPercentage();
        Integer other$requestPercentage = other.getRequestPercentage();
        if (this$requestPercentage == null ? other$requestPercentage != null : !((Object)this$requestPercentage).equals(other$requestPercentage)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaUserQuotas;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $producerByteRate = this.getProducerByteRate();
        result = result * 59 + ($producerByteRate == null ? 43 : ((Object)$producerByteRate).hashCode());
        Integer $consumerByteRate = this.getConsumerByteRate();
        result = result * 59 + ($consumerByteRate == null ? 43 : ((Object)$consumerByteRate).hashCode());
        Integer $requestPercentage = this.getRequestPercentage();
        result = result * 59 + ($requestPercentage == null ? 43 : ((Object)$requestPercentage).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

