/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.CertSecretSource;
import io.strimzi.api.kafka.model.CertSecretSourceBuilder;
import io.strimzi.api.kafka.model.CertSecretSourceFluentImpl;
import io.strimzi.api.kafka.model.KafkaMirrorMaker2Tls;
import io.strimzi.api.kafka.model.KafkaMirrorMaker2TlsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class KafkaMirrorMaker2TlsFluentImpl<A extends KafkaMirrorMaker2TlsFluent<A>>
extends BaseFluent<A>
implements KafkaMirrorMaker2TlsFluent<A> {
    private List<CertSecretSourceBuilder> trustedCertificates;

    public KafkaMirrorMaker2TlsFluentImpl() {
    }

    public KafkaMirrorMaker2TlsFluentImpl(KafkaMirrorMaker2Tls instance) {
        this.withTrustedCertificates(instance.getTrustedCertificates());
    }

    @Override
    public A addToTrustedCertificates(int index, CertSecretSource item) {
        if (this.trustedCertificates == null) {
            this.trustedCertificates = new ArrayList<CertSecretSourceBuilder>();
        }
        CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
        this._visitables.get((Object)"trustedCertificates").add(index >= 0 ? index : this._visitables.get((Object)"trustedCertificates").size(), builder);
        this.trustedCertificates.add(index >= 0 ? index : this.trustedCertificates.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTrustedCertificates(int index, CertSecretSource item) {
        if (this.trustedCertificates == null) {
            this.trustedCertificates = new ArrayList<CertSecretSourceBuilder>();
        }
        CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"trustedCertificates").size()) {
            this._visitables.get((Object)"trustedCertificates").add(builder);
        } else {
            this._visitables.get((Object)"trustedCertificates").set(index, builder);
        }
        if (index < 0 || index >= this.trustedCertificates.size()) {
            this.trustedCertificates.add(builder);
        } else {
            this.trustedCertificates.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTrustedCertificates(CertSecretSource ... items) {
        if (this.trustedCertificates == null) {
            this.trustedCertificates = new ArrayList<CertSecretSourceBuilder>();
        }
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"trustedCertificates").add(builder);
            this.trustedCertificates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTrustedCertificates(Collection<CertSecretSource> items) {
        if (this.trustedCertificates == null) {
            this.trustedCertificates = new ArrayList<CertSecretSourceBuilder>();
        }
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"trustedCertificates").add(builder);
            this.trustedCertificates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTrustedCertificates(CertSecretSource ... items) {
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"trustedCertificates").remove(builder);
            if (this.trustedCertificates == null) continue;
            this.trustedCertificates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTrustedCertificates(Collection<CertSecretSource> items) {
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"trustedCertificates").remove(builder);
            if (this.trustedCertificates == null) continue;
            this.trustedCertificates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTrustedCertificates(Predicate<CertSecretSourceBuilder> predicate) {
        if (this.trustedCertificates == null) {
            return (A)this;
        }
        Iterator<CertSecretSourceBuilder> each = this.trustedCertificates.iterator();
        List visitables = this._visitables.get((Object)"trustedCertificates");
        while (each.hasNext()) {
            CertSecretSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<CertSecretSource> getTrustedCertificates() {
        return KafkaMirrorMaker2TlsFluentImpl.build(this.trustedCertificates);
    }

    @Override
    public List<CertSecretSource> buildTrustedCertificates() {
        return KafkaMirrorMaker2TlsFluentImpl.build(this.trustedCertificates);
    }

    @Override
    public CertSecretSource buildTrustedCertificate(int index) {
        return this.trustedCertificates.get(index).build();
    }

    @Override
    public CertSecretSource buildFirstTrustedCertificate() {
        return this.trustedCertificates.get(0).build();
    }

    @Override
    public CertSecretSource buildLastTrustedCertificate() {
        return this.trustedCertificates.get(this.trustedCertificates.size() - 1).build();
    }

    @Override
    public CertSecretSource buildMatchingTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        for (CertSecretSourceBuilder item : this.trustedCertificates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        for (CertSecretSourceBuilder item : this.trustedCertificates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTrustedCertificates(List<CertSecretSource> trustedCertificates) {
        if (this.trustedCertificates != null) {
            this._visitables.get((Object)"trustedCertificates").removeAll(this.trustedCertificates);
        }
        if (trustedCertificates != null) {
            this.trustedCertificates = new ArrayList<CertSecretSourceBuilder>();
            for (CertSecretSource item : trustedCertificates) {
                this.addToTrustedCertificates(item);
            }
        } else {
            this.trustedCertificates = null;
        }
        return (A)this;
    }

    @Override
    public A withTrustedCertificates(CertSecretSource ... trustedCertificates) {
        if (this.trustedCertificates != null) {
            this.trustedCertificates.clear();
        }
        if (trustedCertificates != null) {
            for (CertSecretSource item : trustedCertificates) {
                this.addToTrustedCertificates(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTrustedCertificates() {
        return this.trustedCertificates != null && !this.trustedCertificates.isEmpty();
    }

    @Override
    public KafkaMirrorMaker2TlsFluent.TrustedCertificatesNested<A> addNewTrustedCertificate() {
        return new TrustedCertificatesNestedImpl();
    }

    @Override
    public KafkaMirrorMaker2TlsFluent.TrustedCertificatesNested<A> addNewTrustedCertificateLike(CertSecretSource item) {
        return new TrustedCertificatesNestedImpl(-1, item);
    }

    @Override
    public KafkaMirrorMaker2TlsFluent.TrustedCertificatesNested<A> setNewTrustedCertificateLike(int index, CertSecretSource item) {
        return new TrustedCertificatesNestedImpl(index, item);
    }

    @Override
    public KafkaMirrorMaker2TlsFluent.TrustedCertificatesNested<A> editTrustedCertificate(int index) {
        if (this.trustedCertificates.size() <= index) {
            throw new RuntimeException("Can't edit trustedCertificates. Index exceeds size.");
        }
        return this.setNewTrustedCertificateLike(index, this.buildTrustedCertificate(index));
    }

    @Override
    public KafkaMirrorMaker2TlsFluent.TrustedCertificatesNested<A> editFirstTrustedCertificate() {
        if (this.trustedCertificates.size() == 0) {
            throw new RuntimeException("Can't edit first trustedCertificates. The list is empty.");
        }
        return this.setNewTrustedCertificateLike(0, this.buildTrustedCertificate(0));
    }

    @Override
    public KafkaMirrorMaker2TlsFluent.TrustedCertificatesNested<A> editLastTrustedCertificate() {
        int index = this.trustedCertificates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last trustedCertificates. The list is empty.");
        }
        return this.setNewTrustedCertificateLike(index, this.buildTrustedCertificate(index));
    }

    @Override
    public KafkaMirrorMaker2TlsFluent.TrustedCertificatesNested<A> editMatchingTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.trustedCertificates.size(); ++i) {
            if (!predicate.test(this.trustedCertificates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching trustedCertificates. No match found.");
        }
        return this.setNewTrustedCertificateLike(index, this.buildTrustedCertificate(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaMirrorMaker2TlsFluentImpl that = (KafkaMirrorMaker2TlsFluentImpl)o;
        return !(this.trustedCertificates != null ? !this.trustedCertificates.equals(that.trustedCertificates) : that.trustedCertificates != null);
    }

    public int hashCode() {
        return Objects.hash(this.trustedCertificates, super.hashCode());
    }

    public class TrustedCertificatesNestedImpl<N>
    extends CertSecretSourceFluentImpl<KafkaMirrorMaker2TlsFluent.TrustedCertificatesNested<N>>
    implements KafkaMirrorMaker2TlsFluent.TrustedCertificatesNested<N>,
    Nested<N> {
        private final CertSecretSourceBuilder builder;
        private final int index;

        TrustedCertificatesNestedImpl(int index, CertSecretSource item) {
            this.index = index;
            this.builder = new CertSecretSourceBuilder(this, item);
        }

        TrustedCertificatesNestedImpl() {
            this.index = -1;
            this.builder = new CertSecretSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaMirrorMaker2TlsFluentImpl.this.setToTrustedCertificates(this.index, this.builder.build());
        }

        @Override
        public N endTrustedCertificate() {
            return this.and();
        }
    }
}

