/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.KafkaConnectSpec;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import io.strimzi.crdgenerator.annotations.KubeLink;

@DescriptionFile
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"version", "replicas", "image", "buildResources", "bootstrapServers", "tls", "authentication", "config", "resources", "livenessProbe", "readinessProbe", "jvmOptions", "jmxOptions", "affinity", "tolerations", "logging", "metrics", "tracing", "template", "externalConfiguration"})
public class KafkaConnectS2ISpec
extends KafkaConnectSpec {
    private static final long serialVersionUID = 1L;
    private ResourceRequirements buildResources;
    private boolean insecureSourceRepository = false;

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @KubeLink(group="core", version="v1", kind="resourcerequirements")
    @Description(value="CPU and memory resources to reserve.")
    public ResourceRequirements getBuildResources() {
        return this.buildResources;
    }

    public void setBuildResources(ResourceRequirements buildResources) {
        this.buildResources = buildResources;
    }

    @Description(value="When true this configures the source repository with the 'Local' reference policy and an import policy that accepts insecure source tags.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isInsecureSourceRepository() {
        return this.insecureSourceRepository;
    }

    public void setInsecureSourceRepository(boolean insecureSourceRepository) {
        this.insecureSourceRepository = insecureSourceRepository;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaConnectS2ISpec)) {
            return false;
        }
        KafkaConnectS2ISpec other = (KafkaConnectS2ISpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceRequirements this$buildResources = this.getBuildResources();
        ResourceRequirements other$buildResources = other.getBuildResources();
        if (this$buildResources == null ? other$buildResources != null : !this$buildResources.equals(other$buildResources)) {
            return false;
        }
        return this.isInsecureSourceRepository() == other.isInsecureSourceRepository();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaConnectS2ISpec;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ResourceRequirements $buildResources = this.getBuildResources();
        result = result * 59 + ($buildResources == null ? 43 : $buildResources.hashCode());
        result = result * 59 + (this.isInsecureSourceRepository() ? 79 : 97);
        return result;
    }
}

