/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.KafkaAuthorizationCustom;
import io.strimzi.api.kafka.model.KafkaAuthorizationCustomFluent;
import io.strimzi.api.kafka.model.KafkaAuthorizationCustomFluentImpl;
import java.util.Objects;

public class KafkaAuthorizationCustomBuilder
extends KafkaAuthorizationCustomFluentImpl<KafkaAuthorizationCustomBuilder>
implements VisitableBuilder<KafkaAuthorizationCustom, KafkaAuthorizationCustomBuilder> {
    KafkaAuthorizationCustomFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaAuthorizationCustomBuilder() {
        this(true);
    }

    public KafkaAuthorizationCustomBuilder(Boolean validationEnabled) {
        this(new KafkaAuthorizationCustom(), validationEnabled);
    }

    public KafkaAuthorizationCustomBuilder(KafkaAuthorizationCustomFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KafkaAuthorizationCustomBuilder(KafkaAuthorizationCustomFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KafkaAuthorizationCustom(), validationEnabled);
    }

    public KafkaAuthorizationCustomBuilder(KafkaAuthorizationCustomFluent<?> fluent, KafkaAuthorizationCustom instance) {
        this(fluent, instance, true);
    }

    public KafkaAuthorizationCustomBuilder(KafkaAuthorizationCustomFluent<?> fluent, KafkaAuthorizationCustom instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAuthorizerClass(instance.getAuthorizerClass());
        fluent.withSuperUsers(instance.getSuperUsers());
        this.validationEnabled = validationEnabled;
    }

    public KafkaAuthorizationCustomBuilder(KafkaAuthorizationCustom instance) {
        this(instance, (Boolean)true);
    }

    public KafkaAuthorizationCustomBuilder(KafkaAuthorizationCustom instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAuthorizerClass(instance.getAuthorizerClass());
        this.withSuperUsers(instance.getSuperUsers());
        this.validationEnabled = validationEnabled;
    }

    public KafkaAuthorizationCustom build() {
        KafkaAuthorizationCustom buildable = new KafkaAuthorizationCustom();
        buildable.setAuthorizerClass(this.fluent.getAuthorizerClass());
        buildable.setSuperUsers(this.fluent.getSuperUsers());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaAuthorizationCustomBuilder that = (KafkaAuthorizationCustomBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

