/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.JmxTransSpec;
import io.strimzi.api.kafka.model.JmxTransSpecFluent;
import io.strimzi.api.kafka.model.JmxTransSpecFluentImpl;
import java.util.Objects;

public class JmxTransSpecBuilder
extends JmxTransSpecFluentImpl<JmxTransSpecBuilder>
implements VisitableBuilder<JmxTransSpec, JmxTransSpecBuilder> {
    JmxTransSpecFluent<?> fluent;
    Boolean validationEnabled;

    public JmxTransSpecBuilder() {
        this(true);
    }

    public JmxTransSpecBuilder(Boolean validationEnabled) {
        this(new JmxTransSpec(), validationEnabled);
    }

    public JmxTransSpecBuilder(JmxTransSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public JmxTransSpecBuilder(JmxTransSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new JmxTransSpec(), validationEnabled);
    }

    public JmxTransSpecBuilder(JmxTransSpecFluent<?> fluent, JmxTransSpec instance) {
        this(fluent, instance, true);
    }

    public JmxTransSpecBuilder(JmxTransSpecFluent<?> fluent, JmxTransSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withImage(instance.getImage());
        fluent.withLogLevel(instance.getLogLevel());
        fluent.withOutputDefinitions(instance.getOutputDefinitions());
        fluent.withKafkaQueries(instance.getKafkaQueries());
        fluent.withResources(instance.getResources());
        fluent.withTemplate(instance.getTemplate());
        this.validationEnabled = validationEnabled;
    }

    public JmxTransSpecBuilder(JmxTransSpec instance) {
        this(instance, (Boolean)true);
    }

    public JmxTransSpecBuilder(JmxTransSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withImage(instance.getImage());
        this.withLogLevel(instance.getLogLevel());
        this.withOutputDefinitions(instance.getOutputDefinitions());
        this.withKafkaQueries(instance.getKafkaQueries());
        this.withResources(instance.getResources());
        this.withTemplate(instance.getTemplate());
        this.validationEnabled = validationEnabled;
    }

    public JmxTransSpec build() {
        JmxTransSpec buildable = new JmxTransSpec();
        buildable.setImage(this.fluent.getImage());
        buildable.setLogLevel(this.fluent.getLogLevel());
        buildable.setOutputDefinitions(this.fluent.getOutputDefinitions());
        buildable.setKafkaQueries(this.fluent.getKafkaQueries());
        buildable.setResources(this.fluent.getResources());
        buildable.setTemplate(this.fluent.getTemplate());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JmxTransSpecBuilder that = (JmxTransSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

