/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.InlineLogging;
import io.strimzi.api.kafka.model.InlineLoggingFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class InlineLoggingFluentImpl<A extends InlineLoggingFluent<A>>
extends BaseFluent<A>
implements InlineLoggingFluent<A> {
    private Map<String, String> loggers;

    public InlineLoggingFluentImpl() {
    }

    public InlineLoggingFluentImpl(InlineLogging instance) {
        this.withLoggers(instance.getLoggers());
    }

    @Override
    public A addToLoggers(String key, String value) {
        if (this.loggers == null && key != null && value != null) {
            this.loggers = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.loggers.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToLoggers(Map<String, String> map) {
        if (this.loggers == null && map != null) {
            this.loggers = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.loggers.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromLoggers(String key) {
        if (this.loggers == null) {
            return (A)this;
        }
        if (key != null && this.loggers != null) {
            this.loggers.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromLoggers(Map<String, String> map) {
        if (this.loggers == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.loggers == null) continue;
                this.loggers.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getLoggers() {
        return this.loggers;
    }

    @Override
    public <K, V> A withLoggers(Map<String, String> loggers) {
        this.loggers = loggers == null ? null : new LinkedHashMap<String, String>(loggers);
        return (A)this;
    }

    @Override
    public Boolean hasLoggers() {
        return this.loggers != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InlineLoggingFluentImpl that = (InlineLoggingFluentImpl)o;
        return !(this.loggers != null ? !this.loggers.equals(that.loggers) : that.loggers != null);
    }

    public int hashCode() {
        return Objects.hash(this.loggers, super.hashCode());
    }
}

