/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka;

import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionSpecFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersion;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersionBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersionFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceSubresourceStatus;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceValidationFluent;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.CustomResourceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.internal.KubernetesDeserializer;
import io.strimzi.api.kafka.KafkaBridgeList;
import io.strimzi.api.kafka.KafkaConnectList;
import io.strimzi.api.kafka.KafkaConnectS2IList;
import io.strimzi.api.kafka.KafkaConnectorList;
import io.strimzi.api.kafka.KafkaList;
import io.strimzi.api.kafka.KafkaMirrorMaker2List;
import io.strimzi.api.kafka.KafkaMirrorMakerList;
import io.strimzi.api.kafka.KafkaRebalanceList;
import io.strimzi.api.kafka.KafkaTopicList;
import io.strimzi.api.kafka.KafkaUserList;
import io.strimzi.api.kafka.model.Kafka;
import io.strimzi.api.kafka.model.KafkaBridge;
import io.strimzi.api.kafka.model.KafkaConnect;
import io.strimzi.api.kafka.model.KafkaConnectS2I;
import io.strimzi.api.kafka.model.KafkaConnector;
import io.strimzi.api.kafka.model.KafkaMirrorMaker;
import io.strimzi.api.kafka.model.KafkaMirrorMaker2;
import io.strimzi.api.kafka.model.KafkaRebalance;
import io.strimzi.api.kafka.model.KafkaTopic;
import io.strimzi.api.kafka.model.KafkaUser;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Crds {
    private static final Class<? extends CustomResource>[] CRDS = new Class[]{Kafka.class, KafkaConnect.class, KafkaConnectS2I.class, KafkaTopic.class, KafkaUser.class, KafkaMirrorMaker.class, KafkaBridge.class, KafkaConnector.class, KafkaMirrorMaker2.class, KafkaRebalance.class};

    private Crds() {
    }

    public static void registerCustomKinds() {
        for (Class<? extends CustomResource> crdClass : CRDS) {
            for (String version : Crds.apiVersions(crdClass)) {
                KubernetesDeserializer.registerCustomKind((String)version, (String)Crds.kind(crdClass), crdClass);
            }
        }
    }

    private static CustomResourceDefinition crd(Class<? extends CustomResource> cls) {
        List<String> versions;
        String listKind;
        String kind;
        String group;
        String singular;
        String plural;
        String scope;
        CustomResourceSubresourceStatus status = null;
        if (cls.equals(Kafka.class)) {
            scope = "Namespaced";
            plural = "kafkas";
            singular = "kafka";
            group = "kafka.strimzi.io";
            kind = "Kafka";
            listKind = "KafkaList";
            versions = Kafka.VERSIONS;
            status = new CustomResourceSubresourceStatus();
        } else if (cls.equals(KafkaConnect.class)) {
            scope = "Namespaced";
            plural = "kafkaconnects";
            singular = "kafkaconnect";
            group = "kafka.strimzi.io";
            kind = "KafkaConnect";
            listKind = "KafkaConnectList";
            versions = KafkaConnect.VERSIONS;
            status = new CustomResourceSubresourceStatus();
        } else if (cls.equals(KafkaConnectS2I.class)) {
            scope = "Namespaced";
            plural = "kafkaconnects2is";
            singular = "kafkaconnects2i";
            group = "kafka.strimzi.io";
            kind = "KafkaConnectS2I";
            listKind = "KafkaConnectS2IList";
            versions = KafkaConnectS2I.VERSIONS;
            status = new CustomResourceSubresourceStatus();
        } else if (cls.equals(KafkaTopic.class)) {
            scope = "Namespaced";
            plural = "kafkatopics";
            singular = "kafkatopic";
            group = "kafka.strimzi.io";
            kind = "KafkaTopic";
            listKind = "KafkaTopicList";
            versions = KafkaTopic.VERSIONS;
        } else if (cls.equals(KafkaUser.class)) {
            scope = "Namespaced";
            plural = "kafkausers";
            singular = "kafkauser";
            group = "kafka.strimzi.io";
            kind = "KafkaUser";
            listKind = "KafkaUserList";
            versions = KafkaUser.VERSIONS;
            status = new CustomResourceSubresourceStatus();
        } else if (cls.equals(KafkaMirrorMaker.class)) {
            scope = "Namespaced";
            plural = "kafkamirrormakers";
            singular = "kafkamirrormaker";
            group = "kafka.strimzi.io";
            kind = "KafkaMirrorMaker";
            listKind = "KafkaMirrorMakerList";
            versions = KafkaMirrorMaker.VERSIONS;
            status = new CustomResourceSubresourceStatus();
        } else if (cls.equals(KafkaBridge.class)) {
            scope = "Namespaced";
            plural = "kafkabridges";
            singular = "kafkabridge";
            group = "kafka.strimzi.io";
            kind = "KafkaBridge";
            listKind = "KafkaBridgeList";
            versions = KafkaBridge.VERSIONS;
            status = new CustomResourceSubresourceStatus();
        } else if (cls.equals(KafkaConnector.class)) {
            scope = "Namespaced";
            plural = "kafkaconnectors";
            singular = "kafkaconnector";
            group = "kafka.strimzi.io";
            kind = "KafkaConnector";
            listKind = "KafkaConnectorList";
            versions = KafkaConnector.VERSIONS;
            status = new CustomResourceSubresourceStatus();
        } else if (cls.equals(KafkaMirrorMaker2.class)) {
            scope = "Namespaced";
            plural = "kafkamirrormaker2s";
            singular = "kafkamirrormaker2";
            group = "kafka.strimzi.io";
            kind = "KafkaMirrorMaker2";
            listKind = "KafkaMirrorMaker2List";
            versions = KafkaMirrorMaker2.VERSIONS;
            status = new CustomResourceSubresourceStatus();
        } else if (cls.equals(KafkaRebalance.class)) {
            scope = "Namespaced";
            plural = "kafkarebalances";
            singular = "kafkarebalance";
            group = "kafka.strimzi.io";
            kind = "KafkaRebalance";
            listKind = "KafkaRebalanceList";
            versions = KafkaRebalance.VERSIONS;
            status = new CustomResourceSubresourceStatus();
        } else {
            throw new RuntimeException();
        }
        ArrayList<CustomResourceDefinitionVersion> crVersions = new ArrayList<CustomResourceDefinitionVersion>(versions.size());
        for (String apiVersion : versions) {
            crVersions.add(((CustomResourceDefinitionVersionBuilder)((CustomResourceDefinitionVersionBuilder)((CustomResourceDefinitionVersionBuilder)((CustomResourceDefinitionVersionFluent.SchemaNested)((CustomResourceValidationFluent.OpenAPIV3SchemaNested)((CustomResourceValidationFluent.OpenAPIV3SchemaNested)((CustomResourceDefinitionVersionBuilder)((CustomResourceDefinitionVersionFluent.SubresourcesNested)((CustomResourceDefinitionVersionBuilder)new CustomResourceDefinitionVersionBuilder().withNewName(apiVersion)).withNewSubresources().withStatus(status)).endSubresources()).withNewSchema().withNewOpenAPIV3Schema().withType("object")).withXKubernetesPreserveUnknownFields(Boolean.valueOf(true))).endOpenAPIV3Schema()).endSchema()).withStorage(Boolean.valueOf("v1beta2".equals(apiVersion)))).withServed(Boolean.valueOf(true))).build());
        }
        return ((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.MetadataNested)new CustomResourceDefinitionBuilder().withNewMetadata().withName(plural + "." + group)).endMetadata()).withNewSpec().withScope(scope)).withGroup(group)).withVersions(crVersions)).withNewNames().withSingular(singular)).withPlural(plural)).withKind(kind)).withListKind(listKind)).endNames()).endSpec()).build();
    }

    public static CustomResourceDefinition kafka() {
        return Crds.crd(Kafka.class);
    }

    public static MixedOperation<Kafka, KafkaList, Resource<Kafka>> kafkaOperation(KubernetesClient client) {
        return client.customResources(Kafka.class, KafkaList.class);
    }

    public static CustomResourceDefinition kafkaConnect() {
        return Crds.crd(KafkaConnect.class);
    }

    public static MixedOperation<KafkaConnect, KafkaConnectList, Resource<KafkaConnect>> kafkaConnectOperation(KubernetesClient client) {
        return client.customResources(KafkaConnect.class, KafkaConnectList.class);
    }

    public static CustomResourceDefinition kafkaConnector() {
        return Crds.crd(KafkaConnector.class);
    }

    public static MixedOperation<KafkaConnector, KafkaConnectorList, Resource<KafkaConnector>> kafkaConnectorOperation(KubernetesClient client) {
        return client.customResources(KafkaConnector.class, KafkaConnectorList.class);
    }

    public static CustomResourceDefinition kafkaConnectS2I() {
        return Crds.crd(KafkaConnectS2I.class);
    }

    public static MixedOperation<KafkaConnectS2I, KafkaConnectS2IList, Resource<KafkaConnectS2I>> kafkaConnectS2iOperation(KubernetesClient client) {
        return client.customResources(KafkaConnectS2I.class, KafkaConnectS2IList.class);
    }

    public static CustomResourceDefinition kafkaTopic() {
        return Crds.crd(KafkaTopic.class);
    }

    public static MixedOperation<KafkaTopic, KafkaTopicList, Resource<KafkaTopic>> topicOperation(KubernetesClient client) {
        return client.customResources(KafkaTopic.class, KafkaTopicList.class);
    }

    public static CustomResourceDefinition kafkaUser() {
        return Crds.crd(KafkaUser.class);
    }

    public static MixedOperation<KafkaUser, KafkaUserList, Resource<KafkaUser>> kafkaUserOperation(KubernetesClient client) {
        return client.customResources(KafkaUser.class, KafkaUserList.class);
    }

    public static CustomResourceDefinition kafkaMirrorMaker() {
        return Crds.crd(KafkaMirrorMaker.class);
    }

    public static MixedOperation<KafkaMirrorMaker, KafkaMirrorMakerList, Resource<KafkaMirrorMaker>> mirrorMakerOperation(KubernetesClient client) {
        return client.customResources(KafkaMirrorMaker.class, KafkaMirrorMakerList.class);
    }

    public static CustomResourceDefinition kafkaBridge() {
        return Crds.crd(KafkaBridge.class);
    }

    public static MixedOperation<KafkaBridge, KafkaBridgeList, Resource<KafkaBridge>> kafkaBridgeOperation(KubernetesClient client) {
        return client.customResources(KafkaBridge.class, KafkaBridgeList.class);
    }

    public static CustomResourceDefinition kafkaMirrorMaker2() {
        return Crds.crd(KafkaMirrorMaker2.class);
    }

    public static MixedOperation<KafkaMirrorMaker2, KafkaMirrorMaker2List, Resource<KafkaMirrorMaker2>> kafkaMirrorMaker2Operation(KubernetesClient client) {
        return client.customResources(KafkaMirrorMaker2.class, KafkaMirrorMaker2List.class);
    }

    public static CustomResourceDefinition kafkaRebalance() {
        return Crds.crd(KafkaRebalance.class);
    }

    public static MixedOperation<KafkaRebalance, KafkaRebalanceList, Resource<KafkaRebalance>> kafkaRebalanceOperation(KubernetesClient client) {
        return client.customResources(KafkaRebalance.class, KafkaRebalanceList.class);
    }

    public static <T extends CustomResource, L extends CustomResourceList<T>> MixedOperation<T, L, Resource<T>> operation(KubernetesClient client, Class<T> cls, Class<L> listCls) {
        return client.customResources(cls, listCls);
    }

    public static <T extends CustomResource> String kind(Class<T> cls) {
        try {
            return ((CustomResource)cls.newInstance()).getKind();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends CustomResource> List<String> apiVersions(Class<T> cls) {
        try {
            List<CallSite> versions;
            String group = (String)cls.getField("RESOURCE_GROUP").get(null);
            try {
                versions = Collections.singletonList(group + "/" + (String)cls.getField("VERSION").get(null));
            }
            catch (NoSuchFieldException e) {
                versions = ((List)cls.getField("VERSIONS").get(null)).stream().map(v -> group + "/" + v).collect(Collectors.toList());
            }
            return versions;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getNumCrds() {
        return CRDS.length;
    }
}

