/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.listener.arraylistener;

import io.fabric8.kubernetes.api.model.LabelSelectorRequirement;
import io.fabric8.kubernetes.api.model.LabelSelectorRequirementBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerFluent;
import io.strimzi.api.kafka.model.listener.IngressListenerBrokerConfiguration;
import io.strimzi.api.kafka.model.listener.IngressListenerBrokerConfigurationBuilder;
import io.strimzi.api.kafka.model.listener.IngressListenerConfigurationFluent;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthentication;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTls;
import io.strimzi.api.kafka.model.listener.KafkaListenerExternal;
import io.strimzi.api.kafka.model.listener.KafkaListenerExternalConfigurationFluent;
import io.strimzi.api.kafka.model.listener.KafkaListenerExternalIngress;
import io.strimzi.api.kafka.model.listener.KafkaListenerExternalIngressBuilder;
import io.strimzi.api.kafka.model.listener.KafkaListenerExternalIngressFluent;
import io.strimzi.api.kafka.model.listener.KafkaListenerExternalLoadBalancer;
import io.strimzi.api.kafka.model.listener.KafkaListenerExternalLoadBalancerBuilder;
import io.strimzi.api.kafka.model.listener.KafkaListenerExternalLoadBalancerFluent;
import io.strimzi.api.kafka.model.listener.KafkaListenerExternalNodePort;
import io.strimzi.api.kafka.model.listener.KafkaListenerExternalNodePortBuilder;
import io.strimzi.api.kafka.model.listener.KafkaListenerExternalNodePortFluent;
import io.strimzi.api.kafka.model.listener.KafkaListenerExternalRoute;
import io.strimzi.api.kafka.model.listener.KafkaListenerExternalRouteBuilder;
import io.strimzi.api.kafka.model.listener.KafkaListenerExternalRouteFluent;
import io.strimzi.api.kafka.model.listener.KafkaListenerPlain;
import io.strimzi.api.kafka.model.listener.KafkaListenerPlainBuilder;
import io.strimzi.api.kafka.model.listener.KafkaListenerTls;
import io.strimzi.api.kafka.model.listener.KafkaListenerTlsBuilder;
import io.strimzi.api.kafka.model.listener.KafkaListenerTlsFluent;
import io.strimzi.api.kafka.model.listener.KafkaListeners;
import io.strimzi.api.kafka.model.listener.KafkaListenersBuilder;
import io.strimzi.api.kafka.model.listener.KafkaListenersFluent;
import io.strimzi.api.kafka.model.listener.LoadBalancerListenerBrokerOverride;
import io.strimzi.api.kafka.model.listener.LoadBalancerListenerBrokerOverrideBuilder;
import io.strimzi.api.kafka.model.listener.LoadBalancerListenerOverrideFluent;
import io.strimzi.api.kafka.model.listener.NodeAddressType;
import io.strimzi.api.kafka.model.listener.NodePortListenerBrokerOverride;
import io.strimzi.api.kafka.model.listener.NodePortListenerBrokerOverrideBuilder;
import io.strimzi.api.kafka.model.listener.NodePortListenerOverrideFluent;
import io.strimzi.api.kafka.model.listener.RouteListenerBrokerOverride;
import io.strimzi.api.kafka.model.listener.RouteListenerBrokerOverrideBuilder;
import io.strimzi.api.kafka.model.listener.RouteListenerOverrideFluent;
import io.strimzi.api.kafka.model.listener.TlsListenerConfigurationFluent;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker;
import io.strimzi.api.kafka.model.listener.arraylistener.KafkaListenerType;
import io.strimzi.api.kafka.model.listener.arraylistener.ListenersConvertor;
import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;

public class ListenersConvertorTest {
    private static final NetworkPolicyPeer NETWORK_POLICY_PEER_1 = ((NetworkPolicyPeerBuilder)((NetworkPolicyPeerFluent.PodSelectorNested)new NetworkPolicyPeerBuilder().withNewPodSelector().withMatchExpressions(new LabelSelectorRequirement[]{((LabelSelectorRequirementBuilder)((LabelSelectorRequirementBuilder)new LabelSelectorRequirementBuilder().withKey("my-key1")).withValues(new String[]{"my-value1"})).build()})).endPodSelector()).build();
    private static final NetworkPolicyPeer NETWORK_POLICY_PEER_2 = ((NetworkPolicyPeerBuilder)((NetworkPolicyPeerFluent.NamespaceSelectorNested)new NetworkPolicyPeerBuilder().withNewNamespaceSelector().withMatchExpressions(new LabelSelectorRequirement[]{((LabelSelectorRequirementBuilder)((LabelSelectorRequirementBuilder)new LabelSelectorRequirementBuilder().withKey("my-key2")).withValues(new String[]{"my-value2"})).build()})).endNamespaceSelector()).build();

    @Test
    public void testConvertToNewFormat() {
        KafkaListeners oldListeners = ((KafkaListenersBuilder)((KafkaListenersFluent.KafkaListenerExternalRouteNested)((KafkaListenersBuilder)((KafkaListenersFluent.TlsNested)((KafkaListenersBuilder)((KafkaListenersFluent.PlainNested)new KafkaListenersBuilder().withNewPlain().withAuth((KafkaListenerAuthentication)new KafkaListenerAuthenticationScramSha512())).endPlain()).withNewTls().withAuth((KafkaListenerAuthentication)new KafkaListenerAuthenticationTls())).endTls()).withNewKafkaListenerExternalRoute().withAuth((KafkaListenerAuthentication)new KafkaListenerAuthenticationTls())).endKafkaListenerExternalRoute()).build();
        List newListners = ListenersConvertor.convertToNewFormat((KafkaListeners)oldListeners);
        MatcherAssert.assertThat((Object)newListners, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)newListners.size(), (Matcher)CoreMatchers.is((Object)3));
        GenericKafkaListener plain = newListners.stream().filter(list -> "plain".equals(list.getName())).findFirst().orElseThrow(() -> new RuntimeException());
        MatcherAssert.assertThat((Object)plain.getAuth().getType(), (Matcher)CoreMatchers.is((Object)"scram-sha-512"));
        GenericKafkaListener tls = newListners.stream().filter(list -> "tls".equals(list.getName())).findFirst().orElseThrow(() -> new RuntimeException());
        MatcherAssert.assertThat((Object)tls.getAuth().getType(), (Matcher)CoreMatchers.is((Object)"tls"));
        GenericKafkaListener external = newListners.stream().filter(list -> "external".equals(list.getName())).findFirst().orElseThrow(() -> new RuntimeException());
        MatcherAssert.assertThat((Object)external.getType(), (Matcher)CoreMatchers.is((Object)KafkaListenerType.ROUTE));
        MatcherAssert.assertThat((Object)external.getAuth().getType(), (Matcher)CoreMatchers.is((Object)"tls"));
    }

    @Test
    public void testConvertToNewFormatSingle() {
        KafkaListeners oldListeners = ((KafkaListenersBuilder)((KafkaListenersFluent.PlainNested)new KafkaListenersBuilder().withNewPlain().withAuth((KafkaListenerAuthentication)new KafkaListenerAuthenticationScramSha512())).endPlain()).build();
        List newListners = ListenersConvertor.convertToNewFormat((KafkaListeners)oldListeners);
        MatcherAssert.assertThat((Object)newListners, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)newListners.size(), (Matcher)CoreMatchers.is((Object)1));
        GenericKafkaListener plain = newListners.stream().filter(list -> "plain".equals(list.getName())).findFirst().orElseThrow(() -> new RuntimeException());
        MatcherAssert.assertThat((Object)plain.getAuth().getType(), (Matcher)CoreMatchers.is((Object)"scram-sha-512"));
    }

    @Test
    public void testConvertToNewFormatEmpty() {
        KafkaListeners oldListeners = new KafkaListenersBuilder().build();
        List newListners = ListenersConvertor.convertToNewFormat((KafkaListeners)oldListeners);
        MatcherAssert.assertThat((Object)newListners, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)newListners.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testConvertToNewFormatNull() {
        List newListners = ListenersConvertor.convertToNewFormat(null);
        MatcherAssert.assertThat((Object)newListners, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)newListners.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testConvertSimplePlainListener() {
        KafkaListenerPlain oldPlain = new KafkaListenerPlainBuilder().build();
        GenericKafkaListener newPlain = ListenersConvertor.convertPlainListener((KafkaListenerPlain)oldPlain);
        MatcherAssert.assertThat((Object)newPlain.getName(), (Matcher)CoreMatchers.is((Object)"plain"));
        MatcherAssert.assertThat((Object)newPlain.getPort(), (Matcher)CoreMatchers.is((Object)9092));
        MatcherAssert.assertThat((Object)newPlain.getType(), (Matcher)CoreMatchers.is((Object)KafkaListenerType.INTERNAL));
        MatcherAssert.assertThat((Object)newPlain.getAuth(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)newPlain.isTls(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)newPlain.getNetworkPolicyPeers(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)newPlain.getConfiguration(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testConvertPlainListener() {
        KafkaListenerPlain oldPlain = ((KafkaListenerPlainBuilder)((KafkaListenerPlainBuilder)new KafkaListenerPlainBuilder().withAuth((KafkaListenerAuthentication)new KafkaListenerAuthenticationScramSha512())).withNetworkPolicyPeers(new NetworkPolicyPeer[]{NETWORK_POLICY_PEER_1, NETWORK_POLICY_PEER_2})).build();
        GenericKafkaListener newPlain = ListenersConvertor.convertPlainListener((KafkaListenerPlain)oldPlain);
        MatcherAssert.assertThat((Object)newPlain.getName(), (Matcher)CoreMatchers.is((Object)"plain"));
        MatcherAssert.assertThat((Object)newPlain.getPort(), (Matcher)CoreMatchers.is((Object)9092));
        MatcherAssert.assertThat((Object)newPlain.getType(), (Matcher)CoreMatchers.is((Object)KafkaListenerType.INTERNAL));
        MatcherAssert.assertThat((Object)newPlain.getAuth().getType(), (Matcher)CoreMatchers.is((Object)"scram-sha-512"));
        MatcherAssert.assertThat((Object)newPlain.isTls(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)newPlain.getNetworkPolicyPeers().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)newPlain.getNetworkPolicyPeers(), (Matcher)CoreMatchers.hasItems((Object[])new NetworkPolicyPeer[]{NETWORK_POLICY_PEER_1, NETWORK_POLICY_PEER_2}));
        MatcherAssert.assertThat((Object)newPlain.getConfiguration(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testConvertSimpleTlsListener() {
        KafkaListenerTls oldTls = new KafkaListenerTlsBuilder().build();
        GenericKafkaListener newTls = ListenersConvertor.convertTlsListener((KafkaListenerTls)oldTls);
        MatcherAssert.assertThat((Object)newTls.getName(), (Matcher)CoreMatchers.is((Object)"tls"));
        MatcherAssert.assertThat((Object)newTls.getPort(), (Matcher)CoreMatchers.is((Object)9093));
        MatcherAssert.assertThat((Object)newTls.getType(), (Matcher)CoreMatchers.is((Object)KafkaListenerType.INTERNAL));
        MatcherAssert.assertThat((Object)newTls.getAuth(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)newTls.isTls(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)newTls.getNetworkPolicyPeers(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)newTls.getConfiguration(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testConvertTlsListener() {
        KafkaListenerTls oldTls = ((KafkaListenerTlsBuilder)((KafkaListenerTlsFluent.ConfigurationNested)((TlsListenerConfigurationFluent.BrokerCertChainAndKeyNested)((TlsListenerConfigurationFluent.BrokerCertChainAndKeyNested)((TlsListenerConfigurationFluent.BrokerCertChainAndKeyNested)((KafkaListenerTlsBuilder)((KafkaListenerTlsBuilder)new KafkaListenerTlsBuilder().withAuth((KafkaListenerAuthentication)new KafkaListenerAuthenticationScramSha512())).withNetworkPolicyPeers(new NetworkPolicyPeer[]{NETWORK_POLICY_PEER_1, NETWORK_POLICY_PEER_2})).withNewConfiguration().withNewBrokerCertChainAndKey().withCertificate("cert")).withKey("key")).withSecretName("secretName")).endBrokerCertChainAndKey()).endConfiguration()).build();
        GenericKafkaListener newTls = ListenersConvertor.convertTlsListener((KafkaListenerTls)oldTls);
        MatcherAssert.assertThat((Object)newTls.getName(), (Matcher)CoreMatchers.is((Object)"tls"));
        MatcherAssert.assertThat((Object)newTls.getPort(), (Matcher)CoreMatchers.is((Object)9093));
        MatcherAssert.assertThat((Object)newTls.getType(), (Matcher)CoreMatchers.is((Object)KafkaListenerType.INTERNAL));
        MatcherAssert.assertThat((Object)newTls.getAuth().getType(), (Matcher)CoreMatchers.is((Object)"scram-sha-512"));
        MatcherAssert.assertThat((Object)newTls.isTls(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)newTls.getNetworkPolicyPeers().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)newTls.getNetworkPolicyPeers(), (Matcher)CoreMatchers.hasItems((Object[])new NetworkPolicyPeer[]{NETWORK_POLICY_PEER_1, NETWORK_POLICY_PEER_2}));
        MatcherAssert.assertThat((Object)newTls.getConfiguration(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)newTls.getConfiguration().getBrokerCertChainAndKey().getCertificate(), (Matcher)CoreMatchers.is((Object)"cert"));
        MatcherAssert.assertThat((Object)newTls.getConfiguration().getBrokerCertChainAndKey().getKey(), (Matcher)CoreMatchers.is((Object)"key"));
        MatcherAssert.assertThat((Object)newTls.getConfiguration().getBrokerCertChainAndKey().getSecretName(), (Matcher)CoreMatchers.is((Object)"secretName"));
    }

    @Test
    public void testConvertSimpleRouteListener() {
        KafkaListenerExternalRoute oldListener = new KafkaListenerExternalRouteBuilder().build();
        GenericKafkaListener newListener = ListenersConvertor.convertExternalListener((KafkaListenerExternal)oldListener);
        MatcherAssert.assertThat((Object)newListener.getName(), (Matcher)CoreMatchers.is((Object)"external"));
        MatcherAssert.assertThat((Object)newListener.getPort(), (Matcher)CoreMatchers.is((Object)9094));
        MatcherAssert.assertThat((Object)newListener.getType(), (Matcher)CoreMatchers.is((Object)KafkaListenerType.ROUTE));
        MatcherAssert.assertThat((Object)newListener.getAuth(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)newListener.isTls(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)newListener.getNetworkPolicyPeers(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)newListener.getConfiguration(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testConvertRouteListener() {
        KafkaListenerExternalRoute oldListener = ((KafkaListenerExternalRouteBuilder)((KafkaListenerExternalRouteFluent.OverridesNested)((KafkaListenerExternalRouteFluent.OverridesNested)((RouteListenerOverrideFluent.BootstrapNested)((RouteListenerOverrideFluent.BootstrapNested)((KafkaListenerExternalRouteBuilder)((KafkaListenerExternalRouteFluent.ConfigurationNested)((KafkaListenerExternalConfigurationFluent.BrokerCertChainAndKeyNested)((KafkaListenerExternalConfigurationFluent.BrokerCertChainAndKeyNested)((KafkaListenerExternalConfigurationFluent.BrokerCertChainAndKeyNested)((KafkaListenerExternalRouteBuilder)((KafkaListenerExternalRouteBuilder)new KafkaListenerExternalRouteBuilder().withAuth((KafkaListenerAuthentication)new KafkaListenerAuthenticationScramSha512())).withNetworkPolicyPeers(new NetworkPolicyPeer[]{NETWORK_POLICY_PEER_1, NETWORK_POLICY_PEER_2})).withNewConfiguration().withNewBrokerCertChainAndKey().withCertificate("cert")).withKey("key")).withSecretName("secretName")).endBrokerCertChainAndKey()).endConfiguration()).withNewOverrides().withNewBootstrap().withHost("my-bootstrap-host")).withAddress("my-bootstrap-dns")).endBootstrap()).withBrokers(new RouteListenerBrokerOverride[]{((RouteListenerBrokerOverrideBuilder)((RouteListenerBrokerOverrideBuilder)((RouteListenerBrokerOverrideBuilder)((RouteListenerBrokerOverrideBuilder)new RouteListenerBrokerOverrideBuilder().withBroker(Integer.valueOf(0))).withAdvertisedHost("my-advertised-host-0")).withAdvertisedPort(Integer.valueOf(1234))).withHost("my-host-0")).build(), ((RouteListenerBrokerOverrideBuilder)((RouteListenerBrokerOverrideBuilder)((RouteListenerBrokerOverrideBuilder)((RouteListenerBrokerOverrideBuilder)new RouteListenerBrokerOverrideBuilder().withBroker(Integer.valueOf(1))).withAdvertisedHost("my-advertised-host-1")).withAdvertisedPort(Integer.valueOf(1234))).withHost("my-host-1")).build()})).endOverrides()).build();
        GenericKafkaListener newListener = ListenersConvertor.convertExternalListener((KafkaListenerExternal)oldListener);
        MatcherAssert.assertThat((Object)newListener.getName(), (Matcher)CoreMatchers.is((Object)"external"));
        MatcherAssert.assertThat((Object)newListener.getPort(), (Matcher)CoreMatchers.is((Object)9094));
        MatcherAssert.assertThat((Object)newListener.getType(), (Matcher)CoreMatchers.is((Object)KafkaListenerType.ROUTE));
        MatcherAssert.assertThat((Object)newListener.getAuth().getType(), (Matcher)CoreMatchers.is((Object)"scram-sha-512"));
        MatcherAssert.assertThat((Object)newListener.isTls(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)newListener.getNetworkPolicyPeers().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)newListener.getNetworkPolicyPeers(), (Matcher)CoreMatchers.hasItems((Object[])new NetworkPolicyPeer[]{NETWORK_POLICY_PEER_1, NETWORK_POLICY_PEER_2}));
        MatcherAssert.assertThat((Object)newListener.getConfiguration(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)newListener.getConfiguration().getBrokerCertChainAndKey().getCertificate(), (Matcher)CoreMatchers.is((Object)"cert"));
        MatcherAssert.assertThat((Object)newListener.getConfiguration().getBrokerCertChainAndKey().getKey(), (Matcher)CoreMatchers.is((Object)"key"));
        MatcherAssert.assertThat((Object)newListener.getConfiguration().getBrokerCertChainAndKey().getSecretName(), (Matcher)CoreMatchers.is((Object)"secretName"));
        MatcherAssert.assertThat((Object)newListener.getConfiguration().getBootstrap().getHost(), (Matcher)CoreMatchers.is((Object)"my-bootstrap-host"));
        MatcherAssert.assertThat((Object)newListener.getConfiguration().getBootstrap().getAlternativeNames().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((String)newListener.getConfiguration().getBootstrap().getAlternativeNames().get(0)), (Matcher)CoreMatchers.is((Object)"my-bootstrap-dns"));
        MatcherAssert.assertThat((Object)newListener.getConfiguration().getBrokers().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(0)).getBroker(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(0)).getAdvertisedHost(), (Matcher)CoreMatchers.is((Object)"my-advertised-host-0"));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(0)).getAdvertisedPort(), (Matcher)CoreMatchers.is((Object)1234));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(0)).getHost(), (Matcher)CoreMatchers.is((Object)"my-host-0"));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(1)).getBroker(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(1)).getAdvertisedHost(), (Matcher)CoreMatchers.is((Object)"my-advertised-host-1"));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(1)).getAdvertisedPort(), (Matcher)CoreMatchers.is((Object)1234));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(1)).getHost(), (Matcher)CoreMatchers.is((Object)"my-host-1"));
    }

    @Test
    public void testConvertSimpleLoadBalancerListener() {
        KafkaListenerExternalLoadBalancer oldListener = new KafkaListenerExternalLoadBalancerBuilder().build();
        GenericKafkaListener newListener = ListenersConvertor.convertExternalListener((KafkaListenerExternal)oldListener);
        MatcherAssert.assertThat((Object)newListener.getName(), (Matcher)CoreMatchers.is((Object)"external"));
        MatcherAssert.assertThat((Object)newListener.getPort(), (Matcher)CoreMatchers.is((Object)9094));
        MatcherAssert.assertThat((Object)newListener.getType(), (Matcher)CoreMatchers.is((Object)KafkaListenerType.LOADBALANCER));
        MatcherAssert.assertThat((Object)newListener.getAuth(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)newListener.isTls(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)newListener.getNetworkPolicyPeers(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)newListener.getConfiguration(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testConvertLoadBalancerListener() {
        KafkaListenerExternalLoadBalancer oldListener = ((KafkaListenerExternalLoadBalancerBuilder)((KafkaListenerExternalLoadBalancerFluent.OverridesNested)((KafkaListenerExternalLoadBalancerFluent.OverridesNested)((LoadBalancerListenerOverrideFluent.BootstrapNested)((LoadBalancerListenerOverrideFluent.BootstrapNested)((LoadBalancerListenerOverrideFluent.BootstrapNested)((KafkaListenerExternalLoadBalancerBuilder)((KafkaListenerExternalLoadBalancerFluent.ConfigurationNested)((KafkaListenerExternalConfigurationFluent.BrokerCertChainAndKeyNested)((KafkaListenerExternalConfigurationFluent.BrokerCertChainAndKeyNested)((KafkaListenerExternalConfigurationFluent.BrokerCertChainAndKeyNested)((KafkaListenerExternalLoadBalancerBuilder)((KafkaListenerExternalLoadBalancerBuilder)((KafkaListenerExternalLoadBalancerBuilder)new KafkaListenerExternalLoadBalancerBuilder().withAuth((KafkaListenerAuthentication)new KafkaListenerAuthenticationScramSha512())).withNetworkPolicyPeers(new NetworkPolicyPeer[]{NETWORK_POLICY_PEER_1, NETWORK_POLICY_PEER_2})).withTls(false)).withNewConfiguration().withNewBrokerCertChainAndKey().withCertificate("cert")).withKey("key")).withSecretName("secretName")).endBrokerCertChainAndKey()).endConfiguration()).withNewOverrides().withNewBootstrap().withLoadBalancerIP("64.23.234.148")).withAddress("my-bootstrap-dns")).withDnsAnnotations(Collections.singletonMap("anno", "my-dns"))).endBootstrap()).withBrokers(new LoadBalancerListenerBrokerOverride[]{((LoadBalancerListenerBrokerOverrideBuilder)((LoadBalancerListenerBrokerOverrideBuilder)((LoadBalancerListenerBrokerOverrideBuilder)((LoadBalancerListenerBrokerOverrideBuilder)((LoadBalancerListenerBrokerOverrideBuilder)new LoadBalancerListenerBrokerOverrideBuilder().withBroker(Integer.valueOf(0))).withAdvertisedHost("my-advertised-host-0")).withAdvertisedPort(Integer.valueOf(1234))).withLoadBalancerIP("64.23.234.149")).withDnsAnnotations(Collections.singletonMap("anno", "my-dns-0"))).build(), ((LoadBalancerListenerBrokerOverrideBuilder)((LoadBalancerListenerBrokerOverrideBuilder)((LoadBalancerListenerBrokerOverrideBuilder)((LoadBalancerListenerBrokerOverrideBuilder)((LoadBalancerListenerBrokerOverrideBuilder)new LoadBalancerListenerBrokerOverrideBuilder().withBroker(Integer.valueOf(1))).withAdvertisedHost("my-advertised-host-1")).withAdvertisedPort(Integer.valueOf(1234))).withLoadBalancerIP("64.23.234.150")).withDnsAnnotations(Collections.singletonMap("anno", "my-dns-1"))).build()})).endOverrides()).build();
        GenericKafkaListener newListener = ListenersConvertor.convertExternalListener((KafkaListenerExternal)oldListener);
        MatcherAssert.assertThat((Object)newListener.getName(), (Matcher)CoreMatchers.is((Object)"external"));
        MatcherAssert.assertThat((Object)newListener.getPort(), (Matcher)CoreMatchers.is((Object)9094));
        MatcherAssert.assertThat((Object)newListener.getType(), (Matcher)CoreMatchers.is((Object)KafkaListenerType.LOADBALANCER));
        MatcherAssert.assertThat((Object)newListener.getAuth().getType(), (Matcher)CoreMatchers.is((Object)"scram-sha-512"));
        MatcherAssert.assertThat((Object)newListener.isTls(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)newListener.getNetworkPolicyPeers().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)newListener.getNetworkPolicyPeers(), (Matcher)CoreMatchers.hasItems((Object[])new NetworkPolicyPeer[]{NETWORK_POLICY_PEER_1, NETWORK_POLICY_PEER_2}));
        MatcherAssert.assertThat((Object)newListener.getConfiguration(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)newListener.getConfiguration().getBrokerCertChainAndKey().getCertificate(), (Matcher)CoreMatchers.is((Object)"cert"));
        MatcherAssert.assertThat((Object)newListener.getConfiguration().getBrokerCertChainAndKey().getKey(), (Matcher)CoreMatchers.is((Object)"key"));
        MatcherAssert.assertThat((Object)newListener.getConfiguration().getBrokerCertChainAndKey().getSecretName(), (Matcher)CoreMatchers.is((Object)"secretName"));
        MatcherAssert.assertThat((Object)newListener.getConfiguration().getBootstrap().getLoadBalancerIP(), (Matcher)CoreMatchers.is((Object)"64.23.234.148"));
        MatcherAssert.assertThat((Object)newListener.getConfiguration().getBootstrap().getAlternativeNames().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((String)newListener.getConfiguration().getBootstrap().getAlternativeNames().get(0)), (Matcher)CoreMatchers.is((Object)"my-bootstrap-dns"));
        MatcherAssert.assertThat((Object)((String)newListener.getConfiguration().getBootstrap().getAnnotations().get("anno")), (Matcher)CoreMatchers.is((Object)"my-dns"));
        MatcherAssert.assertThat((Object)newListener.getConfiguration().getBrokers().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(0)).getBroker(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(0)).getAdvertisedHost(), (Matcher)CoreMatchers.is((Object)"my-advertised-host-0"));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(0)).getAdvertisedPort(), (Matcher)CoreMatchers.is((Object)1234));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(0)).getLoadBalancerIP(), (Matcher)CoreMatchers.is((Object)"64.23.234.149"));
        MatcherAssert.assertThat((Object)((String)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(0)).getAnnotations().get("anno")), (Matcher)CoreMatchers.is((Object)"my-dns-0"));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(1)).getBroker(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(1)).getAdvertisedHost(), (Matcher)CoreMatchers.is((Object)"my-advertised-host-1"));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(1)).getAdvertisedPort(), (Matcher)CoreMatchers.is((Object)1234));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(1)).getLoadBalancerIP(), (Matcher)CoreMatchers.is((Object)"64.23.234.150"));
        MatcherAssert.assertThat((Object)((String)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(1)).getAnnotations().get("anno")), (Matcher)CoreMatchers.is((Object)"my-dns-1"));
    }

    @Test
    public void testConvertSimpleNodePortListener() {
        KafkaListenerExternalNodePort oldListener = new KafkaListenerExternalNodePortBuilder().build();
        GenericKafkaListener newListener = ListenersConvertor.convertExternalListener((KafkaListenerExternal)oldListener);
        MatcherAssert.assertThat((Object)newListener.getName(), (Matcher)CoreMatchers.is((Object)"external"));
        MatcherAssert.assertThat((Object)newListener.getPort(), (Matcher)CoreMatchers.is((Object)9094));
        MatcherAssert.assertThat((Object)newListener.getType(), (Matcher)CoreMatchers.is((Object)KafkaListenerType.NODEPORT));
        MatcherAssert.assertThat((Object)newListener.getAuth(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)newListener.isTls(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)newListener.getNetworkPolicyPeers(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)newListener.getConfiguration(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testConvertNodePortListener() {
        KafkaListenerExternalNodePort oldListener = ((KafkaListenerExternalNodePortBuilder)((KafkaListenerExternalNodePortFluent.OverridesNested)((KafkaListenerExternalNodePortFluent.OverridesNested)((NodePortListenerOverrideFluent.BootstrapNested)((NodePortListenerOverrideFluent.BootstrapNested)((NodePortListenerOverrideFluent.BootstrapNested)((KafkaListenerExternalNodePortBuilder)((KafkaListenerExternalNodePortFluent.ConfigurationNested)((KafkaListenerExternalNodePortFluent.ConfigurationNested)((KafkaListenerExternalConfigurationFluent.BrokerCertChainAndKeyNested)((KafkaListenerExternalConfigurationFluent.BrokerCertChainAndKeyNested)((KafkaListenerExternalConfigurationFluent.BrokerCertChainAndKeyNested)((KafkaListenerExternalNodePortBuilder)((KafkaListenerExternalNodePortBuilder)((KafkaListenerExternalNodePortBuilder)new KafkaListenerExternalNodePortBuilder().withAuth((KafkaListenerAuthentication)new KafkaListenerAuthenticationScramSha512())).withNetworkPolicyPeers(new NetworkPolicyPeer[]{NETWORK_POLICY_PEER_1, NETWORK_POLICY_PEER_2})).withTls(false)).withNewConfiguration().withNewBrokerCertChainAndKey().withCertificate("cert")).withKey("key")).withSecretName("secretName")).endBrokerCertChainAndKey()).withPreferredAddressType(NodeAddressType.EXTERNAL_IP)).endConfiguration()).withNewOverrides().withNewBootstrap().withNodePort(Integer.valueOf(31000))).withAddress("my-bootstrap-dns")).withDnsAnnotations(Collections.singletonMap("anno", "my-dns"))).endBootstrap()).withBrokers(new NodePortListenerBrokerOverride[]{((NodePortListenerBrokerOverrideBuilder)((NodePortListenerBrokerOverrideBuilder)((NodePortListenerBrokerOverrideBuilder)((NodePortListenerBrokerOverrideBuilder)((NodePortListenerBrokerOverrideBuilder)new NodePortListenerBrokerOverrideBuilder().withBroker(Integer.valueOf(0))).withAdvertisedHost("my-advertised-host-0")).withAdvertisedPort(Integer.valueOf(1234))).withNodePort(Integer.valueOf(32000))).withDnsAnnotations(Collections.singletonMap("anno", "my-dns-0"))).build(), ((NodePortListenerBrokerOverrideBuilder)((NodePortListenerBrokerOverrideBuilder)((NodePortListenerBrokerOverrideBuilder)((NodePortListenerBrokerOverrideBuilder)((NodePortListenerBrokerOverrideBuilder)new NodePortListenerBrokerOverrideBuilder().withBroker(Integer.valueOf(1))).withAdvertisedHost("my-advertised-host-1")).withAdvertisedPort(Integer.valueOf(1234))).withNodePort(Integer.valueOf(32001))).withDnsAnnotations(Collections.singletonMap("anno", "my-dns-1"))).build()})).endOverrides()).build();
        GenericKafkaListener newListener = ListenersConvertor.convertExternalListener((KafkaListenerExternal)oldListener);
        MatcherAssert.assertThat((Object)newListener.getName(), (Matcher)CoreMatchers.is((Object)"external"));
        MatcherAssert.assertThat((Object)newListener.getPort(), (Matcher)CoreMatchers.is((Object)9094));
        MatcherAssert.assertThat((Object)newListener.getType(), (Matcher)CoreMatchers.is((Object)KafkaListenerType.NODEPORT));
        MatcherAssert.assertThat((Object)newListener.getAuth().getType(), (Matcher)CoreMatchers.is((Object)"scram-sha-512"));
        MatcherAssert.assertThat((Object)newListener.isTls(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)newListener.getNetworkPolicyPeers().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)newListener.getNetworkPolicyPeers(), (Matcher)CoreMatchers.hasItems((Object[])new NetworkPolicyPeer[]{NETWORK_POLICY_PEER_1, NETWORK_POLICY_PEER_2}));
        MatcherAssert.assertThat((Object)newListener.getConfiguration(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)newListener.getConfiguration().getBrokerCertChainAndKey().getCertificate(), (Matcher)CoreMatchers.is((Object)"cert"));
        MatcherAssert.assertThat((Object)newListener.getConfiguration().getBrokerCertChainAndKey().getKey(), (Matcher)CoreMatchers.is((Object)"key"));
        MatcherAssert.assertThat((Object)newListener.getConfiguration().getBrokerCertChainAndKey().getSecretName(), (Matcher)CoreMatchers.is((Object)"secretName"));
        MatcherAssert.assertThat((Object)newListener.getConfiguration().getPreferredNodePortAddressType(), (Matcher)CoreMatchers.is((Object)NodeAddressType.EXTERNAL_IP));
        MatcherAssert.assertThat((Object)newListener.getConfiguration().getBootstrap().getNodePort(), (Matcher)CoreMatchers.is((Object)31000));
        MatcherAssert.assertThat((Object)newListener.getConfiguration().getBootstrap().getAlternativeNames().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((String)newListener.getConfiguration().getBootstrap().getAlternativeNames().get(0)), (Matcher)CoreMatchers.is((Object)"my-bootstrap-dns"));
        MatcherAssert.assertThat((Object)((String)newListener.getConfiguration().getBootstrap().getAnnotations().get("anno")), (Matcher)CoreMatchers.is((Object)"my-dns"));
        MatcherAssert.assertThat((Object)newListener.getConfiguration().getBrokers().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(0)).getBroker(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(0)).getAdvertisedHost(), (Matcher)CoreMatchers.is((Object)"my-advertised-host-0"));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(0)).getAdvertisedPort(), (Matcher)CoreMatchers.is((Object)1234));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(0)).getNodePort(), (Matcher)CoreMatchers.is((Object)32000));
        MatcherAssert.assertThat((Object)((String)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(0)).getAnnotations().get("anno")), (Matcher)CoreMatchers.is((Object)"my-dns-0"));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(1)).getBroker(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(1)).getAdvertisedHost(), (Matcher)CoreMatchers.is((Object)"my-advertised-host-1"));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(1)).getAdvertisedPort(), (Matcher)CoreMatchers.is((Object)1234));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(1)).getNodePort(), (Matcher)CoreMatchers.is((Object)32001));
        MatcherAssert.assertThat((Object)((String)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(1)).getAnnotations().get("anno")), (Matcher)CoreMatchers.is((Object)"my-dns-1"));
    }

    @Test
    public void testConvertSimpleIngressListener() {
        KafkaListenerExternalIngress oldListener = new KafkaListenerExternalIngressBuilder().build();
        GenericKafkaListener newListener = ListenersConvertor.convertExternalListener((KafkaListenerExternal)oldListener);
        MatcherAssert.assertThat((Object)newListener.getName(), (Matcher)CoreMatchers.is((Object)"external"));
        MatcherAssert.assertThat((Object)newListener.getPort(), (Matcher)CoreMatchers.is((Object)9094));
        MatcherAssert.assertThat((Object)newListener.getType(), (Matcher)CoreMatchers.is((Object)KafkaListenerType.INGRESS));
        MatcherAssert.assertThat((Object)newListener.getAuth(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)newListener.isTls(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)newListener.getNetworkPolicyPeers(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)newListener.getConfiguration(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testConvertIngressListener() {
        KafkaListenerExternalIngress oldListener = ((KafkaListenerExternalIngressBuilder)((KafkaListenerExternalIngressFluent.ConfigurationNested)((KafkaListenerExternalIngressFluent.ConfigurationNested)((IngressListenerConfigurationFluent.BootstrapNested)((IngressListenerConfigurationFluent.BootstrapNested)((IngressListenerConfigurationFluent.BootstrapNested)((KafkaListenerExternalIngressFluent.ConfigurationNested)((KafkaListenerExternalConfigurationFluent.BrokerCertChainAndKeyNested)((KafkaListenerExternalConfigurationFluent.BrokerCertChainAndKeyNested)((KafkaListenerExternalConfigurationFluent.BrokerCertChainAndKeyNested)((KafkaListenerExternalIngressBuilder)((KafkaListenerExternalIngressBuilder)((KafkaListenerExternalIngressBuilder)new KafkaListenerExternalIngressBuilder().withAuth((KafkaListenerAuthentication)new KafkaListenerAuthenticationScramSha512())).withNetworkPolicyPeers(new NetworkPolicyPeer[]{NETWORK_POLICY_PEER_1, NETWORK_POLICY_PEER_2})).withIngressClass("haproxy")).withNewConfiguration().withNewBrokerCertChainAndKey().withCertificate("cert")).withKey("key")).withSecretName("secretName")).endBrokerCertChainAndKey()).withNewBootstrap().withHost("my-bootstrap-host")).withAddress("my-bootstrap-dns")).withDnsAnnotations(Collections.singletonMap("anno", "my-dns"))).endBootstrap()).withBrokers(new IngressListenerBrokerConfiguration[]{((IngressListenerBrokerConfigurationBuilder)((IngressListenerBrokerConfigurationBuilder)((IngressListenerBrokerConfigurationBuilder)((IngressListenerBrokerConfigurationBuilder)((IngressListenerBrokerConfigurationBuilder)new IngressListenerBrokerConfigurationBuilder().withBroker(Integer.valueOf(0))).withAdvertisedHost("my-advertised-host-0")).withAdvertisedPort(Integer.valueOf(1234))).withHost("my-host-0")).withDnsAnnotations(Collections.singletonMap("anno", "my-dns-0"))).build(), ((IngressListenerBrokerConfigurationBuilder)((IngressListenerBrokerConfigurationBuilder)((IngressListenerBrokerConfigurationBuilder)((IngressListenerBrokerConfigurationBuilder)((IngressListenerBrokerConfigurationBuilder)new IngressListenerBrokerConfigurationBuilder().withBroker(Integer.valueOf(1))).withAdvertisedHost("my-advertised-host-1")).withAdvertisedPort(Integer.valueOf(1234))).withHost("my-host-1")).withDnsAnnotations(Collections.singletonMap("anno", "my-dns-1"))).build()})).endConfiguration()).build();
        GenericKafkaListener newListener = ListenersConvertor.convertExternalListener((KafkaListenerExternal)oldListener);
        MatcherAssert.assertThat((Object)newListener.getName(), (Matcher)CoreMatchers.is((Object)"external"));
        MatcherAssert.assertThat((Object)newListener.getPort(), (Matcher)CoreMatchers.is((Object)9094));
        MatcherAssert.assertThat((Object)newListener.getType(), (Matcher)CoreMatchers.is((Object)KafkaListenerType.INGRESS));
        MatcherAssert.assertThat((Object)newListener.getAuth().getType(), (Matcher)CoreMatchers.is((Object)"scram-sha-512"));
        MatcherAssert.assertThat((Object)newListener.isTls(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)newListener.getNetworkPolicyPeers().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)newListener.getNetworkPolicyPeers(), (Matcher)CoreMatchers.hasItems((Object[])new NetworkPolicyPeer[]{NETWORK_POLICY_PEER_1, NETWORK_POLICY_PEER_2}));
        MatcherAssert.assertThat((Object)newListener.getConfiguration(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)newListener.getConfiguration().getIngressClass(), (Matcher)CoreMatchers.is((Object)"haproxy"));
        MatcherAssert.assertThat((Object)newListener.getConfiguration().getBrokerCertChainAndKey().getCertificate(), (Matcher)CoreMatchers.is((Object)"cert"));
        MatcherAssert.assertThat((Object)newListener.getConfiguration().getBrokerCertChainAndKey().getKey(), (Matcher)CoreMatchers.is((Object)"key"));
        MatcherAssert.assertThat((Object)newListener.getConfiguration().getBrokerCertChainAndKey().getSecretName(), (Matcher)CoreMatchers.is((Object)"secretName"));
        MatcherAssert.assertThat((Object)newListener.getConfiguration().getBootstrap().getHost(), (Matcher)CoreMatchers.is((Object)"my-bootstrap-host"));
        MatcherAssert.assertThat((Object)newListener.getConfiguration().getBootstrap().getAlternativeNames().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((String)newListener.getConfiguration().getBootstrap().getAlternativeNames().get(0)), (Matcher)CoreMatchers.is((Object)"my-bootstrap-dns"));
        MatcherAssert.assertThat((Object)((String)newListener.getConfiguration().getBootstrap().getAnnotations().get("anno")), (Matcher)CoreMatchers.is((Object)"my-dns"));
        MatcherAssert.assertThat((Object)newListener.getConfiguration().getBrokers().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(0)).getBroker(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(0)).getAdvertisedHost(), (Matcher)CoreMatchers.is((Object)"my-advertised-host-0"));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(0)).getAdvertisedPort(), (Matcher)CoreMatchers.is((Object)1234));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(0)).getHost(), (Matcher)CoreMatchers.is((Object)"my-host-0"));
        MatcherAssert.assertThat((Object)((String)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(0)).getAnnotations().get("anno")), (Matcher)CoreMatchers.is((Object)"my-dns-0"));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(1)).getBroker(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(1)).getAdvertisedHost(), (Matcher)CoreMatchers.is((Object)"my-advertised-host-1"));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(1)).getAdvertisedPort(), (Matcher)CoreMatchers.is((Object)1234));
        MatcherAssert.assertThat((Object)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(1)).getHost(), (Matcher)CoreMatchers.is((Object)"my-host-1"));
        MatcherAssert.assertThat((Object)((String)((GenericKafkaListenerConfigurationBroker)newListener.getConfiguration().getBrokers().get(1)).getAnnotations().get("anno")), (Matcher)CoreMatchers.is((Object)"my-dns-1"));
    }
}

