/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.AbstractCrdIT;
import io.strimzi.api.kafka.model.KafkaTopic;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.exceptions.KubeClusterException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class KafkaTopicCrdIT
extends AbstractCrdIT {
    public static final String NAMESPACE = "topiccrd-it";

    @Test
    void testKafkaTopicV1alpha1() {
        this.createDeleteCustomResource("KafkaTopicV1alpha1.yaml");
    }

    @Test
    void testKafkaTopicIsNotScaling() {
        Assertions.assertThrows(KubeClusterException.class, () -> this.createScaleDelete(KafkaTopic.class, "KafkaTopic.yaml"));
    }

    @Test
    void testKafkaTopicV1beta1() {
        this.createDeleteCustomResource("KafkaTopicV1beta1.yaml");
    }

    @Test
    void testKafkaTopicMinimal() {
        this.createDeleteCustomResource("KafkaTopic-minimal.yaml");
    }

    @Disabled(value="See https://github.com/strimzi/strimzi-kafka-operator/issues/4606")
    @Test
    void testCreateKafkaTopicWithExtraProperty() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.class, () -> this.createDeleteCustomResource("KafkaTopic-with-extra-property.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"unknown field \"foo\""));
    }

    @BeforeAll
    void setupEnvironment() {
        this.cluster.createNamespace(NAMESPACE);
        this.cluster.createCustomResources(new String[]{TestUtils.CRD_TOPIC});
        this.cluster.waitForCustomResourceDefinition("kafkatopics.kafka.strimzi.io");
    }

    @AfterAll
    void teardownEnvironment() {
        this.cluster.deleteCustomResources();
        this.cluster.deleteNamespaces();
    }
}

