/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.strimzi.api.kafka.model.AbstractCrdTest;
import io.strimzi.api.kafka.model.Kafka;
import io.strimzi.api.kafka.model.KafkaBuilder;
import io.strimzi.api.kafka.model.KafkaFluent;
import io.strimzi.api.kafka.model.KafkaSpecFluent;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthentication;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTls;
import io.strimzi.api.kafka.model.listener.KafkaListeners;
import io.strimzi.api.kafka.model.listener.KafkaListenersBuilder;
import io.strimzi.api.kafka.model.listener.KafkaListenersFluent;
import io.strimzi.api.kafka.model.listener.arraylistener.ArrayOrObjectKafkaListeners;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder;
import io.strimzi.api.kafka.model.listener.arraylistener.KafkaListenerType;
import io.strimzi.test.TestUtils;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;

public class KafkaTest
extends AbstractCrdTest<Kafka> {
    public KafkaTest() {
        super(Kafka.class);
    }

    @Test
    public void testArrayRoundTrip() {
        this.rt("Kafka-with-array");
    }

    @Test
    public void testOldListenerSerialization() throws URISyntaxException {
        KafkaListeners listeners = ((KafkaListenersBuilder)((KafkaListenersFluent.TlsNested)new KafkaListenersBuilder().withNewTls().withAuth((KafkaListenerAuthentication)new KafkaListenerAuthenticationTls())).endTls()).build();
        Kafka kafka = ((KafkaBuilder)((KafkaFluent.SpecNested)((KafkaSpecFluent.EntityOperatorNested)((KafkaSpecFluent.EntityOperatorNested)((KafkaFluent.SpecNested)((KafkaSpecFluent.KafkaNested)((KafkaSpecFluent.KafkaNested)((KafkaSpecFluent.KafkaNested)((KafkaFluent.SpecNested)((KafkaSpecFluent.ZookeeperNested)((KafkaSpecFluent.ZookeeperNested)((KafkaBuilder)((KafkaFluent.MetadataNested)((KafkaFluent.MetadataNested)new KafkaBuilder().withNewMetadata().withName("my-cluster")).withNamespace("my-namespace")).endMetadata()).withNewSpec().withNewZookeeper().withReplicas(1)).withNewEphemeralStorage().endEphemeralStorage()).endZookeeper()).withNewKafka().withReplicas(1)).withListeners(new ArrayOrObjectKafkaListeners(listeners))).withNewEphemeralStorage().endEphemeralStorage()).endKafka()).withNewEntityOperator().withNewTopicOperator().endTopicOperator()).withNewUserOperator().endUserOperator()).endEntityOperator()).endSpec()).build();
        MatcherAssert.assertThat((Object)TestUtils.toYamlString((Object)kafka), (Matcher)CoreMatchers.is((Object)TestUtils.getFileAsString((String)this.getClass().getResource("Kafka-old-listener-serialization.yaml").toURI().getPath())));
    }

    @Test
    public void testCertificationAuthorityBuilderAndInts() throws URISyntaxException {
        List<GenericKafkaListener> listeners = Collections.singletonList(((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)new GenericKafkaListenerBuilder().withName("lst")).withPort(9092)).withType(KafkaListenerType.INTERNAL)).withTls(true)).build());
        Kafka kafka = ((KafkaBuilder)((KafkaFluent.SpecNested)((KafkaSpecFluent.ClusterCaNested)((KafkaFluent.SpecNested)((KafkaSpecFluent.ClientsCaNested)((KafkaFluent.SpecNested)((KafkaSpecFluent.EntityOperatorNested)((KafkaSpecFluent.EntityOperatorNested)((KafkaFluent.SpecNested)((KafkaSpecFluent.KafkaNested)((KafkaSpecFluent.KafkaNested)((KafkaSpecFluent.KafkaNested)((KafkaFluent.SpecNested)((KafkaSpecFluent.ZookeeperNested)((KafkaSpecFluent.ZookeeperNested)((KafkaBuilder)((KafkaFluent.MetadataNested)((KafkaFluent.MetadataNested)new KafkaBuilder().withNewMetadata().withName("my-cluster")).withNamespace("my-namespace")).endMetadata()).withNewSpec().withNewZookeeper().withReplicas(1)).withNewEphemeralStorage().endEphemeralStorage()).endZookeeper()).withNewKafka().withReplicas(1)).withListeners(new ArrayOrObjectKafkaListeners(listeners))).withNewEphemeralStorage().endEphemeralStorage()).endKafka()).withNewEntityOperator().withNewTopicOperator().endTopicOperator()).withNewUserOperator().endUserOperator()).endEntityOperator()).withNewClientsCa().withGenerateSecretOwnerReference(false)).endClientsCa()).withNewClusterCa().withGenerateSecretOwnerReference(false)).endClusterCa()).endSpec()).build();
        MatcherAssert.assertThat((Object)TestUtils.toYamlString((Object)kafka), (Matcher)CoreMatchers.is((Object)TestUtils.getFileAsString((String)this.getClass().getResource("Kafka-ca-ints.yaml").toURI().getPath())));
    }

    @Test
    public void testNewListenerSerialization() throws URISyntaxException {
        List<GenericKafkaListener> listeners = Collections.singletonList(((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)new GenericKafkaListenerBuilder().withName("lst")).withPort(9092)).withType(KafkaListenerType.INTERNAL)).withTls(true)).build());
        Kafka kafka = ((KafkaBuilder)((KafkaFluent.SpecNested)((KafkaSpecFluent.EntityOperatorNested)((KafkaSpecFluent.EntityOperatorNested)((KafkaFluent.SpecNested)((KafkaSpecFluent.KafkaNested)((KafkaSpecFluent.KafkaNested)((KafkaSpecFluent.KafkaNested)((KafkaFluent.SpecNested)((KafkaSpecFluent.ZookeeperNested)((KafkaSpecFluent.ZookeeperNested)((KafkaBuilder)((KafkaFluent.MetadataNested)((KafkaFluent.MetadataNested)new KafkaBuilder().withNewMetadata().withName("my-cluster")).withNamespace("my-namespace")).endMetadata()).withNewSpec().withNewZookeeper().withReplicas(1)).withNewEphemeralStorage().endEphemeralStorage()).endZookeeper()).withNewKafka().withReplicas(1)).withListeners(new ArrayOrObjectKafkaListeners(listeners))).withNewEphemeralStorage().endEphemeralStorage()).endKafka()).withNewEntityOperator().withNewTopicOperator().endTopicOperator()).withNewUserOperator().endUserOperator()).endEntityOperator()).endSpec()).build();
        MatcherAssert.assertThat((Object)TestUtils.toYamlString((Object)kafka), (Matcher)CoreMatchers.is((Object)TestUtils.getFileAsString((String)this.getClass().getResource("Kafka-new-listener-serialization.yaml").toURI().getPath())));
    }

    @Test
    public void testNewListeners() {
        Kafka model = (Kafka)TestUtils.fromYaml((String)"Kafka-with-array.yaml", Kafka.class);
        MatcherAssert.assertThat((Object)model.getSpec().getKafka().getListeners().getGenericKafkaListeners(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)model.getSpec().getKafka().getListeners().getGenericKafkaListeners().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)model.getSpec().getKafka().getListeners().getKafkaListeners(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        List listeners = model.getSpec().getKafka().getListeners().getGenericKafkaListeners();
        MatcherAssert.assertThat((Object)((GenericKafkaListener)listeners.get(0)).getAuth().getType(), (Matcher)CoreMatchers.is((Object)"scram-sha-512"));
        MatcherAssert.assertThat((Object)((GenericKafkaListener)listeners.get(1)).getAuth().getType(), (Matcher)CoreMatchers.is((Object)"tls"));
    }

    @Test
    public void testOldListeners() {
        Kafka model = (Kafka)TestUtils.fromYaml((String)"Kafka.yaml", Kafka.class);
        MatcherAssert.assertThat((Object)model.getSpec().getKafka().getListeners().getGenericKafkaListeners(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)model.getSpec().getKafka().getListeners().getKafkaListeners(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        KafkaListeners listeners = model.getSpec().getKafka().getListeners().getKafkaListeners();
        MatcherAssert.assertThat((Object)listeners.getPlain(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)listeners.getTls(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)listeners.getPlain().getAuth().getType(), (Matcher)CoreMatchers.is((Object)"scram-sha-512"));
        MatcherAssert.assertThat((Object)listeners.getTls().getAuth().getType(), (Matcher)CoreMatchers.is((Object)"tls"));
    }

    public void rt(String resourceName) {
        Kafka model = (Kafka)TestUtils.fromYaml((String)(resourceName + ".yaml"), Kafka.class);
        MatcherAssert.assertThat((String)("The classpath resource " + resourceName + " does not exist"), (Object)model, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ObjectMeta metadata = model.getMetadata();
        MatcherAssert.assertThat((Object)metadata, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.assertDesiredResource(model, resourceName + ".out.yaml");
        this.assertDesiredResource((Kafka)TestUtils.fromYamlString((String)TestUtils.toYamlString((Object)model), Kafka.class), resourceName + ".out.yaml");
    }
}

