/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.AbstractCrdIT;
import io.strimzi.api.kafka.model.KafkaMirrorMaker;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.exceptions.KubeClusterException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class KafkaMirrorMakerCrdIT
extends AbstractCrdIT {
    public static final String NAMESPACE = "kafkamirrormaker-crd-it";

    @Test
    void testKafkaMirrorMakerScaling() {
        this.createScaleDelete(KafkaMirrorMaker.class, "KafkaMirrorMaker.yaml");
    }

    @Test
    void testKafkaMirrorMakerMinimal() {
        this.createDeleteCustomResource("KafkaMirrorMaker-minimal.yaml");
    }

    @Disabled(value="See https://github.com/strimzi/strimzi-kafka-operator/issues/4606")
    @Test
    void testCreateKafkaMirrorMakerWithExtraProperty() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.class, () -> this.createDeleteCustomResource("KafkaMirrorMaker-with-extra-property.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"unknown field \"extra\""));
    }

    @Test
    void testKafkaMirrorMakerWithMissingRequired() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.class, () -> this.createDeleteCustomResource("KafkaMirrorMaker-with-missing-required-property.yaml"));
        this.assertMissingRequiredPropertiesMessage(exception.getMessage(), "bootstrapServers", "producer", "whitelist");
    }

    @Test
    void testKafkaMirrorMakerWithTls() {
        this.createDeleteCustomResource("KafkaMirrorMaker-with-tls.yaml");
    }

    @Test
    void testKafkaMirrorMakerWithTlsAuth() {
        this.createDeleteCustomResource("KafkaMirrorMaker-with-tls-auth.yaml");
    }

    @Test
    void testKafkaMirrorMakerWithTlsAuthWithMissingRequired() {
        Throwable exception = Assertions.assertThrows(KubeClusterException.InvalidResource.class, () -> this.createDeleteCustomResource("KafkaMirrorMaker-with-tls-auth-with-missing-required.yaml"));
        this.assertMissingRequiredPropertiesMessage(exception.getMessage(), "spec.producer.authentication.certificateAndKey.certificate", "spec.producer.authentication.certificateAndKey.key", "spec.whitelist");
    }

    @Test
    void testKafkaMirrorMakerWithScramSha512Auth() {
        this.createDeleteCustomResource("KafkaMirrorMaker-with-scram-sha-512-auth.yaml");
    }

    @Test
    void testKafkaMirrorMakerWithTemplate() {
        this.createDeleteCustomResource("KafkaMirrorMaker-with-template.yaml");
    }

    @Test
    void testKafkaMirrorMakerWithCommitAndAbort() {
        this.createDeleteCustomResource("KafkaMirrorMaker-with-commit-and-abort.yaml");
    }

    @BeforeAll
    void setupEnvironment() {
        this.cluster.createNamespace(NAMESPACE);
        this.cluster.createCustomResources(new String[]{TestUtils.CRD_KAFKA_MIRROR_MAKER});
        this.cluster.waitForCustomResourceDefinition("kafkamirrormakers.kafka.strimzi.io");
    }

    @AfterAll
    void teardownEnvironment() {
        this.cluster.deleteCustomResources();
        this.cluster.deleteNamespaces();
    }
}

