/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.JvmOptions;
import io.strimzi.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;

public class JvmOptionsTest {
    @Test
    public void testSetXmxXms() {
        JvmOptions opts = (JvmOptions)TestUtils.fromJson((String)"{  \"-Xmx\": \"2g\",  \"-Xms\": \"1g\"}", JvmOptions.class);
        MatcherAssert.assertThat((Object)opts.getXms(), (Matcher)CoreMatchers.is((Object)"1g"));
        MatcherAssert.assertThat((Object)opts.getXmx(), (Matcher)CoreMatchers.is((Object)"2g"));
    }

    @Test
    public void testEmptyXmxXms() {
        JvmOptions opts = (JvmOptions)TestUtils.fromJson((String)"{}", JvmOptions.class);
        MatcherAssert.assertThat((Object)opts.getXms(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)opts.getXmx(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testXx() {
        JvmOptions opts = (JvmOptions)TestUtils.fromJson((String)"{    \"-XX\":            {\"key1\": \"value1\",            \"key2\": \"value2\",            \"key3\": \"true\",            \"key4\": true,            \"key5\": 10}}", JvmOptions.class);
        MatcherAssert.assertThat((Object)opts.getXx(), (Matcher)CoreMatchers.is((Object)TestUtils.map((Object[])new String[]{"key1", "value1", "key2", "value2", "key3", "true", "key4", "true", "key5", "10"})));
        opts = (JvmOptions)TestUtils.fromJson((String)"{}", JvmOptions.class);
        MatcherAssert.assertThat((Object)opts.getXx(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

