/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.strimzi.api.annotations.ApiVersion;
import io.strimzi.api.annotations.KubeVersion;
import io.strimzi.api.annotations.VersionRange;
import io.strimzi.api.kafka.Crds;
import io.strimzi.api.kafka.KafkaList;
import io.strimzi.api.kafka.model.AbstractCrdIT;
import io.strimzi.api.kafka.model.Kafka;
import io.strimzi.api.kafka.model.KafkaBuilder;
import io.strimzi.api.kafka.model.KafkaClusterSpec;
import io.strimzi.api.kafka.model.KafkaFluent;
import io.strimzi.api.kafka.model.KafkaSpecFluent;
import io.strimzi.api.kafka.model.listener.KafkaListeners;
import io.strimzi.api.kafka.model.listener.KafkaListenersBuilder;
import io.strimzi.api.kafka.model.listener.arraylistener.ArrayOrObjectKafkaListeners;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder;
import io.strimzi.api.kafka.model.listener.arraylistener.KafkaListenerType;
import io.strimzi.crdgenerator.CrdGenerator;
import io.strimzi.test.TestUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class ApiEvolutionCrdIT
extends AbstractCrdIT {
    private static final Logger LOGGER = LogManager.getLogger(ApiEvolutionCrdIT.class);
    public static final String NAMESPACE = "api-evolution-it";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void kafkaApiEvolution() throws IOException, InterruptedException {
        this.assumeKube1_16Plus();
        try {
            LOGGER.info("Phase 1 : Create CRD");
            io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition crdPhase1 = ((CrdV1Beta1Builder)((CrdV1Beta1Builder)((CrdV1Beta1Builder)new CrdV1Beta1Builder().withVersions(ApiVersion.V1ALPHA1, ApiVersion.V1BETA1)).withServedVersions((VersionRange<ApiVersion>)ApiVersion.V1BETA1_PLUS)).withStorageVersion(ApiVersion.V1BETA1)).createOrReplace();
            Thread.sleep(5000L);
            this.waitForCrdUpdate(crdPhase1.getMetadata().getGeneration());
            LOGGER.info("Phase 1 : Create instances");
            String nameA = "instance.a";
            String nameB = "instance.b";
            Kafka instanceA = this.v1beta1Create("instance.a", this.mapListener(), null);
            Kafka instanceB = this.v1beta1Create("instance.b", null, this.listListener());
            LOGGER.info("Phase 1 : Assert instances via v1beta1");
            this.assertIsMapListener(this.v1beta1Get("instance.a"));
            this.assertIsListListener(this.v1beta1Get("instance.b"));
            ((Resource)this.v1beta1Op().withName("instance.a")).replace((Object)((KafkaBuilder)((KafkaFluent.SpecNested)((KafkaSpecFluent.KafkaNested)new KafkaBuilder(instanceA).editSpec().editKafka().withListeners(new ArrayOrObjectKafkaListeners(instanceA.getSpec().getKafka().getListeners().newOrConverted()))).endKafka()).endSpec()).build());
            LOGGER.info("Phase 2 : Replace CRD, removing v1alpha1, adding v1beta2");
            io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition crdPhase2 = ((CrdV1Beta1Builder)((CrdV1Beta1Builder)((CrdV1Beta1Builder)new CrdV1Beta1Builder().withVersions(ApiVersion.V1BETA1, ApiVersion.V1BETA2)).withServedVersions((VersionRange<ApiVersion>)ApiVersion.V1BETA1_PLUS)).withStorageVersion(ApiVersion.V1BETA2)).createOrReplace();
            this.waitForCrdUpdate(crdPhase2.getMetadata().getGeneration());
            Assertions.assertEquals((Object)"v1beta2", (Object)crdPhase2.getSpec().getVersions().stream().filter(v -> v.getStorage()).map(v -> v.getName()).findFirst().get());
            this.assertV1beta2CreateFailure("not.valid");
            String nameC = "instance.c";
            Kafka instanceC = this.v1beta2Create("instance.c", null, this.listListener());
            LOGGER.info("Phase 2 : Upgrading all instances to new stored version");
            instanceA = this.touchV1Beta2("instance.a");
            instanceB = this.touchV1Beta2("instance.b");
            instanceC = this.touchV1Beta2("instance.c");
            LOGGER.info("Phase 2 : Assert instances via both endpoints");
            this.assertIsListListener(this.v1beta1Get("instance.a"));
            this.assertIsListListener(this.v1beta1Get("instance.b"));
            this.assertIsListListener(this.v1beta1Get("instance.c"));
            this.assertIsListListener(this.v1beta2Get("instance.a"));
            this.assertIsListListener(this.v1beta2Get("instance.b"));
            this.assertIsListListener(this.v1beta2Get("instance.c"));
            LOGGER.info("Phase 2 : Updating CRD so v1beta1 has served=false");
            io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition crdPhase2Part2 = (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition)this.cluster.client().getClient().apiextensions().v1beta1().customResourceDefinitions().createOrReplace((Object[])new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition[]{((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionSpecFluent.VersionsNested)new CustomResourceDefinitionBuilder(crdPhase2).editSpec().editLastVersion().withServed(Boolean.valueOf(false))).endVersion()).endSpec()).build()});
            io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition crdPhase2Part3 = this.waitForCrdUpdate(crdPhase2Part2.getMetadata().getGeneration());
            LOGGER.info("Phase 2 : Updating CRD status.stored versions = v1beta2");
            io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition crdPhase2Part4 = (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition)this.cluster.client().getClient().apiextensions().v1beta1().customResourceDefinitions().updateStatus((Object)((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.StatusNested)new CustomResourceDefinitionBuilder(crdPhase2Part3).editStatus().withStoredVersions(Arrays.asList("v1beta2"))).endStatus()).build());
            Assertions.assertEquals(Arrays.asList("v1beta2"), (Object)crdPhase2Part4.getStatus().getStoredVersions());
            this.assertIsListListener(this.v1beta2Get("instance.a"));
            this.assertIsListListener(this.v1beta2Get("instance.b"));
            this.assertIsListListener(this.v1beta2Get("instance.c"));
            LOGGER.info("Phase 3 : Update CRD so v1beta2 is stored");
            CustomResourceDefinition crdPhase3 = ((CrdV1Builder)((CrdV1Builder)((CrdV1Builder)new CrdV1Builder().withVersions(ApiVersion.V1BETA2)).withServedVersions((VersionRange<ApiVersion>)ApiVersion.V1BETA2_PLUS)).withStorageVersion(ApiVersion.V1BETA2)).createOrReplace();
            this.waitForCrdUpdate(crdPhase3.getMetadata().getGeneration());
            Assertions.assertEquals((Object)"v1beta2", (Object)crdPhase3.getSpec().getVersions().stream().filter(v -> v.getStorage()).map(v -> v.getName()).findFirst().get());
            Assertions.assertEquals(Arrays.asList("v1beta2"), (Object)crdPhase3.getStatus().getStoredVersions());
            LOGGER.info("Assert instances via v1beta2 endpoint");
            this.assertIsListListener(this.v1beta2Get("instance.a"));
            this.assertIsListListener(this.v1beta2Get("instance.b"));
            this.assertIsListListener(this.v1beta2Get("instance.c"));
        }
        finally {
            this.deleteCrd();
        }
    }

    public Kafka touchV1Beta2(String name) {
        Kafka build = ((KafkaBuilder)new KafkaBuilder(this.v1beta2Get(name)).withApiVersion("kafka.strimzi.io/v1beta2")).build();
        build = (Kafka)((Resource)this.v1beta2Op().withName(name)).replace((Object)build);
        return build;
    }

    private void assertV1beta2CreateFailure(String name) {
        LOGGER.info("Check can't create map-listener via v1beta2");
        KubernetesClientException e = (KubernetesClientException)Assertions.assertThrows(KubernetesClientException.class, () -> this.v1beta2Create(name, this.mapListener(), null));
        LOGGER.info("Exception, good", (Throwable)e);
        Assertions.assertTrue((boolean)e.getMessage().contains("Kafka.kafka.strimzi.io \"" + name + "\" is invalid: spec.kafka.listeners: Invalid value: \"object\": spec.kafka.listeners in body must be of type array:"));
    }

    private Kafka v1beta1Create(String name, KafkaListeners kafkaListeners, GenericKafkaListener o) {
        return (Kafka)this.v1beta1Op().create((Object)this.buildKafkaCr("v1beta1", name, kafkaListeners, o));
    }

    private Kafka v1beta2Create(String name, KafkaListeners kafkaListeners, GenericKafkaListener o) {
        return (Kafka)this.v1beta2Op().create((Object)this.buildKafkaCr("v1beta2", name, kafkaListeners, o));
    }

    private Kafka v1beta1Get(String s) {
        return (Kafka)((Resource)this.v1beta1Op().withName(s)).get();
    }

    private Kafka v1beta2Get(String s) {
        return (Kafka)((Resource)this.v1beta2Op().withName(s)).get();
    }

    private io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition waitForCrdUpdate(long crdGeneration2) {
        TestUtils.waitFor((String)"CRD update", (long)1000L, (long)30000L, () -> crdGeneration2 == ((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition)((Resource)this.cluster.client().getClient().apiextensions().v1beta1().customResourceDefinitions().withName("kafkas.kafka.strimzi.io")).get()).getMetadata().getGeneration());
        return (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition)((Resource)this.cluster.client().getClient().apiextensions().v1beta1().customResourceDefinitions().withName("kafkas.kafka.strimzi.io")).get();
    }

    private void deleteCrd() {
        KubernetesClientException ex;
        block5: {
            ex = null;
            try {
                ((Resource)this.cluster.client().getClient().apiextensions().v1beta1().customResourceDefinitions().withName("kafkas.kafka.strimzi.io")).delete();
            }
            catch (KubernetesClientException e) {
                ex = e;
                try {
                    ((Resource)this.cluster.client().getClient().apiextensions().v1().customResourceDefinitions().withName("kafkas.kafka.strimzi.io")).delete();
                }
                catch (KubernetesClientException e2) {
                    if (ex != null) break block5;
                    ex = e2;
                }
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    private void assertIsMapListener(Kafka kafka) {
        Assertions.assertNotNull((Object)kafka);
        Assertions.assertNotNull((Object)kafka.getSpec());
        KafkaClusterSpec kafkaSpec = kafka.getSpec().getKafka();
        Assertions.assertNotNull((Object)kafkaSpec);
        ArrayOrObjectKafkaListeners listeners = kafkaSpec.getListeners();
        Assertions.assertNotNull((Object)listeners);
        Assertions.assertNotNull((Object)listeners.getKafkaListeners());
        Assertions.assertNull((Object)listeners.getGenericKafkaListeners());
        Assertions.assertNotNull((Object)kafkaSpec.getConfig());
        Assertions.assertEquals((Object)"someValue", kafkaSpec.getConfig().get("some.kafka.config"));
    }

    private void assertIsListListener(Kafka kafka) {
        Assertions.assertNotNull((Object)kafka);
        Assertions.assertNotNull((Object)kafka.getSpec());
        KafkaClusterSpec kafkaSpec = kafka.getSpec().getKafka();
        Assertions.assertNotNull((Object)kafkaSpec);
        ArrayOrObjectKafkaListeners listeners = kafkaSpec.getListeners();
        Assertions.assertNotNull((Object)listeners);
        Assertions.assertNull((Object)listeners.getKafkaListeners());
        Assertions.assertNotNull((Object)listeners.getGenericKafkaListeners());
        Assertions.assertNotNull((Object)kafkaSpec.getConfig());
        Assertions.assertEquals((Object)"someValue", kafkaSpec.getConfig().get("some.kafka.config"));
    }

    private NonNamespaceOperation<Kafka, KafkaList, Resource<Kafka>> v1beta1Op() {
        CustomResourceDefinition kafka = Crds.kafka();
        CustomResourceDefinitionContext ctx = new CustomResourceDefinitionContext.Builder().withKind(kafka.getSpec().getNames().getKind()).withName(kafka.getSpec().getNames().getSingular()).withPlural(kafka.getSpec().getNames().getPlural()).withScope(kafka.getSpec().getScope()).withGroup(kafka.getSpec().getGroup()).withVersion("v1beta1").build();
        return (NonNamespaceOperation)this.cluster.client().getClient().customResources(ctx, Kafka.class, KafkaList.class).inNamespace(NAMESPACE);
    }

    private NonNamespaceOperation<Kafka, KafkaList, Resource<Kafka>> v1beta2Op() {
        return (NonNamespaceOperation)Crds.kafkaOperation((KubernetesClient)this.cluster.client().getClient()).inNamespace(NAMESPACE);
    }

    private GenericKafkaListener listListener() {
        return ((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)new GenericKafkaListenerBuilder().withType(KafkaListenerType.INTERNAL)).withName("plain")).withPort(9092)).withTls(false)).build();
    }

    private KafkaListeners mapListener() {
        return ((KafkaListenersBuilder)new KafkaListenersBuilder().withNewPlain().endPlain()).build();
    }

    private Kafka buildKafkaCr(String apiVersion, String name, KafkaListeners mapListeners, GenericKafkaListener listListeners) {
        if (mapListeners == null == (listListeners == null)) {
            throw new IllegalArgumentException("Exactly one of mapListeners or listListeners must be non-null");
        }
        return ((KafkaBuilder)((KafkaFluent.SpecNested)((KafkaSpecFluent.ZookeeperNested)((KafkaSpecFluent.ZookeeperNested)((KafkaFluent.SpecNested)((KafkaSpecFluent.KafkaNested)((KafkaSpecFluent.KafkaNested)((KafkaSpecFluent.KafkaNested)((KafkaSpecFluent.KafkaNested)((KafkaBuilder)((KafkaFluent.MetadataNested)((KafkaFluent.MetadataNested)((KafkaBuilder)new KafkaBuilder().withApiVersion(apiVersion)).withNewMetadata().withName(name)).withNamespace(NAMESPACE)).endMetadata()).withNewSpec().withNewKafka().withReplicas(1)).withNewEphemeralStorage().endEphemeralStorage()).withListeners(listListeners != null ? new ArrayOrObjectKafkaListeners(Collections.singletonList(listListeners)) : new ArrayOrObjectKafkaListeners(mapListeners))).addToConfig("some.kafka.config", (Object)"someValue")).endKafka()).withNewZookeeper().withReplicas(1)).withNewEphemeralStorage().endEphemeralStorage()).endZookeeper()).endSpec()).build();
    }

    @BeforeAll
    void setupEnvironment() {
        this.cluster.createNamespace(NAMESPACE);
    }

    @AfterAll
    void teardownEnvironment() {
        this.cluster.deleteNamespaces();
    }

    class CrdV1Builder
    extends Builder<CustomResourceDefinition, CrdV1Builder> {
        CrdV1Builder() {
        }

        private CustomResourceDefinition build() throws IOException {
            StringWriter sw = new StringWriter();
            new CrdGenerator(KubeVersion.V1_16_PLUS, ApiVersion.V1, (ObjectMapper)CrdGenerator.YAML_MAPPER, Collections.emptyMap(), (CrdGenerator.Reporter)new CrdGenerator.DefaultReporter(), Arrays.asList(this.versions), this.storageVersion, this.servedVersions, (CrdGenerator.ConversionStrategy)new CrdGenerator.NoneConversionStrategy(), null).generate(Kafka.class, (Writer)sw);
            return (CustomResourceDefinition)CrdGenerator.YAML_MAPPER.readValue(sw.toString(), CustomResourceDefinition.class);
        }

        @Override
        protected CrdV1Builder self() {
            return this;
        }

        @Override
        public CustomResourceDefinition createOrReplace() throws IOException {
            return (CustomResourceDefinition)ApiEvolutionCrdIT.this.cluster.client().getClient().apiextensions().v1().customResourceDefinitions().createOrReplace((Object[])new CustomResourceDefinition[]{this.build()});
        }
    }

    class CrdV1Beta1Builder
    extends Builder<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition, CrdV1Beta1Builder> {
        CrdV1Beta1Builder() {
        }

        private io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition build() throws IOException {
            StringWriter sw = new StringWriter();
            new CrdGenerator(KubeVersion.V1_16_PLUS, ApiVersion.V1BETA1, (ObjectMapper)CrdGenerator.YAML_MAPPER, Collections.emptyMap(), (CrdGenerator.Reporter)new CrdGenerator.DefaultReporter(), Arrays.asList(this.versions), this.storageVersion, this.servedVersions, (CrdGenerator.ConversionStrategy)new CrdGenerator.NoneConversionStrategy(), null).generate(Kafka.class, (Writer)sw);
            return (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition)CrdGenerator.YAML_MAPPER.readValue(sw.toString(), io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition.class);
        }

        @Override
        protected CrdV1Beta1Builder self() {
            return this;
        }

        @Override
        public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition createOrReplace() throws IOException {
            io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition build = this.build();
            return (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition)ApiEvolutionCrdIT.this.cluster.client().getClient().apiextensions().v1beta1().customResourceDefinitions().createOrReplace((Object[])new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition[]{build});
        }
    }

    abstract class Builder<Crd extends HasMetadata, Self extends Builder<Crd, Self>> {
        protected VersionRange<ApiVersion> servedVersions;
        protected ApiVersion storageVersion;
        protected ApiVersion[] versions;

        Builder() {
        }

        public Self withServedVersions(VersionRange<ApiVersion> apiVersions) {
            this.servedVersions = apiVersions;
            return this.self();
        }

        public Self withStorageVersion(ApiVersion apiVersion) {
            this.storageVersion = apiVersion;
            return this.self();
        }

        public Self withVersions(ApiVersion ... apiVersions) {
            this.versions = apiVersions;
            return this.self();
        }

        protected abstract Self self();

        abstract Crd createOrReplace() throws IOException;
    }
}

